/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.grpclb;

import io.etcd.jetcd.shaded.com.google.common.base.Stopwatch;
import io.etcd.jetcd.shaded.io.grpc.Internal;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancer;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancerProvider;
import io.etcd.jetcd.shaded.io.grpc.NameResolver;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.grpclb.CachedSubchannelPool;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbLoadBalancer;
import io.etcd.jetcd.shaded.io.grpc.grpclb.GrpclbState;
import io.etcd.jetcd.shaded.io.grpc.internal.ExponentialBackoffPolicy;
import io.etcd.jetcd.shaded.io.grpc.internal.ServiceConfigUtil;
import io.etcd.jetcd.shaded.io.grpc.internal.TimeProvider;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.util.List;
import java.util.Map;

@Internal
public final class GrpclbLoadBalancerProvider
extends LoadBalancerProvider {
    private static final GrpclbState.Mode DEFAULT_MODE = GrpclbState.Mode.ROUND_ROBIN;

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "grpclb";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new GrpclbLoadBalancer(helper, new CachedSubchannelPool(), TimeProvider.SYSTEM_TIME_PROVIDER, Stopwatch.createUnstarted(), new ExponentialBackoffPolicy.Provider());
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingConfigPolicy) {
        try {
            return this.parseLoadBalancingConfigPolicyInternal(rawLoadBalancingConfigPolicy);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("can't parse config: " + e.getMessage()).withCause(e));
        }
    }

    NameResolver.ConfigOrError parseLoadBalancingConfigPolicyInternal(Map<String, ?> rawLoadBalancingPolicyConfig) {
        if (rawLoadBalancingPolicyConfig == null) {
            return NameResolver.ConfigOrError.fromConfig((Object)DEFAULT_MODE);
        }
        List<?> rawChildPolicies = GrpclbLoadBalancerProvider.getList(rawLoadBalancingPolicyConfig, "childPolicy");
        if (rawChildPolicies == null) {
            return NameResolver.ConfigOrError.fromConfig((Object)DEFAULT_MODE);
        }
        List<ServiceConfigUtil.LbConfig> childPolicies = ServiceConfigUtil.unwrapLoadBalancingConfigList(GrpclbLoadBalancerProvider.checkObjectList(rawChildPolicies));
        for (ServiceConfigUtil.LbConfig childPolicy : childPolicies) {
            String childPolicyName;
            switch (childPolicyName = childPolicy.getPolicyName()) {
                case "round_robin": {
                    return NameResolver.ConfigOrError.fromConfig((Object)GrpclbState.Mode.ROUND_ROBIN);
                }
                case "pick_first": {
                    return NameResolver.ConfigOrError.fromConfig((Object)GrpclbState.Mode.PICK_FIRST);
                }
            }
        }
        return NameResolver.ConfigOrError.fromConfig((Object)DEFAULT_MODE);
    }

    @Nullable
    private static List<?> getList(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof List)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in %s is not List", value, key, obj));
        }
        return (List)value;
    }

    private static List<Map<String, ?>> checkObjectList(List<?> rawList) {
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof Map) continue;
            throw new ClassCastException(String.format("value %s for idx %d in %s is not object", rawList.get(i), i, rawList));
        }
        return rawList;
    }
}

