/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.opencensus.trace;

import io.etcd.jetcd.shaded.io.opencensus.internal.Utils;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import io.etcd.jetcd.shaded.javax.annotation.concurrent.Immutable;
import java.util.Arrays;

@Immutable
public final class TraceOptions {
    private static final byte DEFAULT_OPTIONS = 0;
    private static final byte IS_SAMPLED = 1;
    public static final int SIZE = 1;
    public static final TraceOptions DEFAULT = TraceOptions.fromByte((byte)0);
    private final byte options;

    private TraceOptions(byte options) {
        this.options = options;
    }

    @Deprecated
    public static TraceOptions fromBytes(byte[] buffer) {
        Utils.checkNotNull(buffer, "buffer");
        Utils.checkArgument(buffer.length == 1, "Invalid size: expected %s, got %s", 1, buffer.length);
        return TraceOptions.fromByte(buffer[0]);
    }

    @Deprecated
    public static TraceOptions fromBytes(byte[] src, int srcOffset) {
        Utils.checkIndex(srcOffset, src.length);
        return TraceOptions.fromByte(src[srcOffset]);
    }

    public static TraceOptions fromByte(byte src) {
        return new TraceOptions(src);
    }

    public byte getByte() {
        return this.options;
    }

    @Deprecated
    public byte[] getBytes() {
        byte[] bytes = new byte[]{this.options};
        return bytes;
    }

    public void copyBytesTo(byte[] dest, int destOffset) {
        Utils.checkIndex(destOffset, dest.length);
        dest[destOffset] = this.options;
    }

    public static Builder builder() {
        return new Builder(0);
    }

    public static Builder builder(TraceOptions traceOptions) {
        return new Builder(traceOptions.options);
    }

    public boolean isSampled() {
        return this.hasOption(1);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraceOptions)) {
            return false;
        }
        TraceOptions that = (TraceOptions)obj;
        return this.options == that.options;
    }

    public int hashCode() {
        return Arrays.hashCode(new byte[]{this.options});
    }

    public String toString() {
        return "TraceOptions{sampled=" + this.isSampled() + "}";
    }

    byte getOptions() {
        return this.options;
    }

    private boolean hasOption(int mask) {
        return (this.options & mask) != 0;
    }

    public static final class Builder {
        private byte options;

        private Builder(byte options) {
            this.options = options;
        }

        @Deprecated
        public Builder setIsSampled() {
            return this.setIsSampled(true);
        }

        public Builder setIsSampled(boolean isSampled) {
            this.options = isSampled ? (byte)(this.options | 1) : (byte)(this.options & 0xFFFFFFFE);
            return this;
        }

        public TraceOptions build() {
            return TraceOptions.fromByte(this.options);
        }
    }
}

