/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.opencensus.trace;

import io.etcd.jetcd.shaded.io.opencensus.internal.Utils;
import io.etcd.jetcd.shaded.io.opencensus.trace.LowerCaseBase16Encoding;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import io.etcd.jetcd.shaded.javax.annotation.concurrent.Immutable;
import java.util.Arrays;
import java.util.Random;

@Immutable
public final class SpanId
implements Comparable<SpanId> {
    public static final int SIZE = 8;
    private static final int HEX_SIZE = 16;
    public static final SpanId INVALID = new SpanId(new byte[8]);
    private final byte[] bytes;

    private SpanId(byte[] bytes) {
        this.bytes = bytes;
    }

    public static SpanId fromBytes(byte[] buffer) {
        Utils.checkNotNull(buffer, "buffer");
        Utils.checkArgument(buffer.length == 8, "Invalid size: expected %s, got %s", 8, buffer.length);
        byte[] bytesCopied = Arrays.copyOf(buffer, 8);
        return new SpanId(bytesCopied);
    }

    public static SpanId fromBytes(byte[] src, int srcOffset) {
        byte[] bytes = new byte[8];
        System.arraycopy(src, srcOffset, bytes, 0, 8);
        return new SpanId(bytes);
    }

    public static SpanId fromLowerBase16(CharSequence src) {
        Utils.checkArgument(src.length() == 16, "Invalid size: expected %s, got %s", 16, src.length());
        return new SpanId(LowerCaseBase16Encoding.decodeToBytes(src));
    }

    public static SpanId generateRandomId(Random random) {
        byte[] bytes = new byte[8];
        do {
            random.nextBytes(bytes);
        } while (Arrays.equals(bytes, SpanId.INVALID.bytes));
        return new SpanId(bytes);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, 8);
    }

    public void copyBytesTo(byte[] dest, int destOffset) {
        System.arraycopy(this.bytes, 0, dest, destOffset, 8);
    }

    public boolean isValid() {
        return !Arrays.equals(this.bytes, SpanId.INVALID.bytes);
    }

    public String toLowerBase16() {
        return LowerCaseBase16Encoding.encodeToString(this.bytes);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpanId)) {
            return false;
        }
        SpanId that = (SpanId)obj;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return "SpanId{spanId=" + this.toLowerBase16() + "}";
    }

    @Override
    public int compareTo(SpanId that) {
        for (int i = 0; i < 8; ++i) {
            if (this.bytes[i] == that.bytes[i]) continue;
            return this.bytes[i] < that.bytes[i] ? -1 : 1;
        }
        return 0;
    }
}

