/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.opencensus.tags;

import io.etcd.jetcd.shaded.io.opencensus.internal.Provider;
import io.etcd.jetcd.shaded.io.opencensus.tags.NoopTags;
import io.etcd.jetcd.shaded.io.opencensus.tags.Tagger;
import io.etcd.jetcd.shaded.io.opencensus.tags.TaggingState;
import io.etcd.jetcd.shaded.io.opencensus.tags.TagsComponent;
import io.etcd.jetcd.shaded.io.opencensus.tags.propagation.TagPropagationComponent;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Tags {
    private static final Logger logger = Logger.getLogger(Tags.class.getName());
    private static final TagsComponent tagsComponent = Tags.loadTagsComponent(TagsComponent.class.getClassLoader());

    private Tags() {
    }

    public static Tagger getTagger() {
        return tagsComponent.getTagger();
    }

    public static TagPropagationComponent getTagPropagationComponent() {
        return tagsComponent.getTagPropagationComponent();
    }

    public static TaggingState getState() {
        return tagsComponent.getState();
    }

    @Deprecated
    public static void setState(TaggingState state) {
        tagsComponent.setState(state);
    }

    static TagsComponent loadTagsComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("io.etcd.jetcd.shaded.io.opencensus.impl.tags.TagsComponentImpl", true, classLoader), TagsComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for TagsComponent, now trying to load lite implementation.", e);
            try {
                return Provider.createInstance(Class.forName("io.etcd.jetcd.shaded.io.opencensus.impllite.tags.TagsComponentImplLite", true, classLoader), TagsComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load lite implementation for TagsComponent, now using default implementation for TagsComponent.", e2);
                return NoopTags.newNoopTagsComponent();
            }
        }
    }
}

