/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.internal;

import io.etcd.jetcd.shaded.com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.io.grpc.Metadata;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.internal.ClientStreamListener;
import io.etcd.jetcd.shaded.io.grpc.internal.NoopClientStream;

public final class FailingClientStream
extends NoopClientStream {
    private boolean started;
    private final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    public FailingClientStream(Status error) {
        this(error, ClientStreamListener.RpcProgress.PROCESSED);
    }

    public FailingClientStream(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public void start(ClientStreamListener listener) {
        Preconditions.checkState(!this.started, "already started");
        this.started = true;
        listener.closed(this.error, this.rpcProgress, new Metadata());
    }

    @VisibleForTesting
    Status getError() {
        return this.error;
    }
}

