/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.internal;

import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.io.grpc.ChannelLogger;
import io.etcd.jetcd.shaded.io.grpc.InternalChannelz;
import io.etcd.jetcd.shaded.io.grpc.internal.ChannelTracer;
import io.etcd.jetcd.shaded.io.grpc.internal.TimeProvider;
import java.text.MessageFormat;
import java.util.logging.Level;

final class ChannelLoggerImpl
extends ChannelLogger {
    private final ChannelTracer tracer;
    private final TimeProvider time;

    ChannelLoggerImpl(ChannelTracer tracer, TimeProvider time) {
        this.tracer = Preconditions.checkNotNull(tracer, "tracer");
        this.time = Preconditions.checkNotNull(time, "time");
    }

    @Override
    public void log(ChannelLogger.ChannelLogLevel level, String msg) {
        Level javaLogLevel = this.toJavaLogLevel(level);
        if (ChannelTracer.logger.isLoggable(javaLogLevel)) {
            this.tracer.logOnly(javaLogLevel, msg);
        }
        if (this.isTraceable(level)) {
            this.trace(level, msg);
        }
    }

    @Override
    public void log(ChannelLogger.ChannelLogLevel level, String messageFormat, Object ... args) {
        Level javaLogLevel = this.toJavaLogLevel(level);
        String msg = null;
        if (ChannelTracer.logger.isLoggable(javaLogLevel)) {
            if (msg == null) {
                msg = MessageFormat.format(messageFormat, args);
            }
            this.tracer.logOnly(javaLogLevel, msg);
        }
        if (this.isTraceable(level)) {
            if (msg == null) {
                msg = MessageFormat.format(messageFormat, args);
            }
            this.trace(level, msg);
        }
    }

    private boolean isTraceable(ChannelLogger.ChannelLogLevel level) {
        return level != ChannelLogger.ChannelLogLevel.DEBUG && this.tracer.isTraceEnabled();
    }

    private void trace(ChannelLogger.ChannelLogLevel level, String msg) {
        if (level == ChannelLogger.ChannelLogLevel.DEBUG) {
            return;
        }
        this.tracer.traceOnly(new InternalChannelz.ChannelTrace.Event.Builder().setDescription(msg).setSeverity(this.toTracerSeverity(level)).setTimestampNanos(this.time.currentTimeNanos()).build());
    }

    private InternalChannelz.ChannelTrace.Event.Severity toTracerSeverity(ChannelLogger.ChannelLogLevel level) {
        switch (level) {
            case ERROR: {
                return InternalChannelz.ChannelTrace.Event.Severity.CT_ERROR;
            }
            case WARNING: {
                return InternalChannelz.ChannelTrace.Event.Severity.CT_WARNING;
            }
        }
        return InternalChannelz.ChannelTrace.Event.Severity.CT_INFO;
    }

    private Level toJavaLogLevel(ChannelLogger.ChannelLogLevel level) {
        switch (level) {
            case ERROR: {
                return Level.FINE;
            }
            case WARNING: {
                return Level.FINER;
            }
        }
        return Level.FINEST;
    }
}

