/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc.internal;

import io.etcd.jetcd.shaded.com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.shaded.com.google.common.base.Ascii;
import io.etcd.jetcd.shaded.io.grpc.Attributes;
import io.etcd.jetcd.shaded.io.grpc.ChannelLogger;
import io.etcd.jetcd.shaded.io.grpc.ConnectivityState;
import io.etcd.jetcd.shaded.io.grpc.ConnectivityStateInfo;
import io.etcd.jetcd.shaded.io.grpc.EquivalentAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancer;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancerProvider;
import io.etcd.jetcd.shaded.io.grpc.LoadBalancerRegistry;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.internal.GrpcAttributes;
import io.etcd.jetcd.shaded.io.grpc.internal.ServiceConfigUtil;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import java.util.List;
import java.util.Map;

final class AutoConfiguredLoadBalancerFactory
extends LoadBalancer.Factory {
    private static final String DEFAULT_POLICY = "pick_first";
    private static final LoadBalancerRegistry registry = LoadBalancerRegistry.getDefaultRegistry();

    AutoConfiguredLoadBalancerFactory() {
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new AutoConfiguredLoadBalancer(helper);
    }

    private static LoadBalancerProvider getProviderOrThrow(String policy, String reason) throws PolicyNotFoundException {
        LoadBalancerProvider provider = registry.getProvider(policy);
        if (provider == null) {
            throw new PolicyNotFoundException(policy, reason);
        }
        return provider;
    }

    private static final class FailingPicker
    extends LoadBalancer.SubchannelPicker {
        private final Status failure;

        FailingPicker(Status failure) {
            this.failure = failure;
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withError(this.failure);
        }
    }

    private static final class EmptyPicker
    extends LoadBalancer.SubchannelPicker {
        private EmptyPicker() {
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withNoResult();
        }
    }

    static final class PolicyNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;
        final String policy;
        final String choiceReason;

        private PolicyNotFoundException(String policy, String choiceReason) {
            this.policy = policy;
            this.choiceReason = choiceReason;
        }

        @Override
        public String getMessage() {
            return "Trying to load '" + this.policy + "' because " + this.choiceReason + ", but it's unavailable";
        }
    }

    @VisibleForTesting
    static final class AutoConfiguredLoadBalancer
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private LoadBalancer delegate;
        private LoadBalancerProvider delegateProvider;

        AutoConfiguredLoadBalancer(LoadBalancer.Helper helper) {
            this.helper = helper;
            this.delegateProvider = registry.getProvider(AutoConfiguredLoadBalancerFactory.DEFAULT_POLICY);
            if (this.delegateProvider == null) {
                throw new IllegalStateException("Could not find LoadBalancer pick_first. The build probably threw away META-INF/services/io.grpc.LoadBalancerProvider");
            }
            this.delegate = this.delegateProvider.newLoadBalancer(helper);
        }

        @Override
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> servers, Attributes attributes) {
            LoadBalancerProvider newlbp;
            Map<String, Object> configMap = attributes.get(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG);
            try {
                newlbp = AutoConfiguredLoadBalancer.decideLoadBalancerProvider(servers, configMap);
            }
            catch (PolicyNotFoundException e) {
                Status s = Status.INTERNAL.withDescription(e.getMessage());
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new FailingPicker(s));
                this.delegate.shutdown();
                this.delegateProvider = null;
                this.delegate = new NoopLoadBalancer();
                return;
            }
            if (this.delegateProvider == null || !newlbp.getPolicyName().equals(this.delegateProvider.getPolicyName())) {
                this.helper.updateBalancingState(ConnectivityState.CONNECTING, new EmptyPicker());
                this.delegate.shutdown();
                this.delegateProvider = newlbp;
                LoadBalancer old = this.delegate;
                this.delegate = this.delegateProvider.newLoadBalancer(this.helper);
                this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Load balancer changed from {0} to {1}", old.getClass().getSimpleName(), this.delegate.getClass().getSimpleName());
            }
            this.getDelegate().handleResolvedAddressGroups(servers, attributes);
        }

        @Override
        public void handleNameResolutionError(Status error) {
            this.getDelegate().handleNameResolutionError(error);
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            this.getDelegate().handleSubchannelState(subchannel, stateInfo);
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
            this.delegate = null;
        }

        @VisibleForTesting
        LoadBalancer getDelegate() {
            return this.delegate;
        }

        @VisibleForTesting
        void setDelegate(LoadBalancer lb) {
            this.delegate = lb;
        }

        @VisibleForTesting
        LoadBalancerProvider getDelegateProvider() {
            return this.delegateProvider;
        }

        @VisibleForTesting
        static LoadBalancerProvider decideLoadBalancerProvider(List<EquivalentAddressGroup> servers, @Nullable Map<String, Object> config) throws PolicyNotFoundException {
            boolean haveBalancerAddress = false;
            for (EquivalentAddressGroup s : servers) {
                if (s.getAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY) == null) continue;
                haveBalancerAddress = true;
                break;
            }
            if (haveBalancerAddress) {
                return AutoConfiguredLoadBalancerFactory.getProviderOrThrow("grpclb", "NameResolver has returned balancer addresses");
            }
            String serviceConfigChoiceBalancingPolicy = null;
            if (config != null && (serviceConfigChoiceBalancingPolicy = ServiceConfigUtil.getLoadBalancingPolicyFromServiceConfig(config)) != null) {
                return AutoConfiguredLoadBalancerFactory.getProviderOrThrow(Ascii.toLowerCase(serviceConfigChoiceBalancingPolicy), "service-config specifies load-balancing policy");
            }
            return AutoConfiguredLoadBalancerFactory.getProviderOrThrow(AutoConfiguredLoadBalancerFactory.DEFAULT_POLICY, "Using default policy");
        }
    }

    private static final class NoopLoadBalancer
    extends LoadBalancer {
        private NoopLoadBalancer() {
        }

        @Override
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> s, Attributes a) {
        }

        @Override
        public void handleNameResolutionError(Status error) {
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        }

        @Override
        public void shutdown() {
        }
    }
}

