/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc;

import io.etcd.jetcd.shaded.com.google.common.base.MoreObjects;
import io.etcd.jetcd.shaded.com.google.common.base.Objects;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.io.grpc.Attributes;
import io.etcd.jetcd.shaded.io.grpc.CallOptions;
import io.etcd.jetcd.shaded.io.grpc.Channel;
import io.etcd.jetcd.shaded.io.grpc.ChannelLogger;
import io.etcd.jetcd.shaded.io.grpc.ClientStreamTracer;
import io.etcd.jetcd.shaded.io.grpc.ConnectivityState;
import io.etcd.jetcd.shaded.io.grpc.ConnectivityStateInfo;
import io.etcd.jetcd.shaded.io.grpc.EquivalentAddressGroup;
import io.etcd.jetcd.shaded.io.grpc.ExperimentalApi;
import io.etcd.jetcd.shaded.io.grpc.Internal;
import io.etcd.jetcd.shaded.io.grpc.ManagedChannel;
import io.etcd.jetcd.shaded.io.grpc.Metadata;
import io.etcd.jetcd.shaded.io.grpc.MethodDescriptor;
import io.etcd.jetcd.shaded.io.grpc.NameResolver;
import io.etcd.jetcd.shaded.io.grpc.Status;
import io.etcd.jetcd.shaded.io.grpc.SynchronizationContext;
import io.etcd.jetcd.shaded.javax.annotation.Nonnull;
import io.etcd.jetcd.shaded.javax.annotation.Nullable;
import io.etcd.jetcd.shaded.javax.annotation.concurrent.Immutable;
import io.etcd.jetcd.shaded.javax.annotation.concurrent.NotThreadSafe;
import io.etcd.jetcd.shaded.javax.annotation.concurrent.ThreadSafe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
@NotThreadSafe
public abstract class LoadBalancer {
    public abstract void handleResolvedAddressGroups(List<EquivalentAddressGroup> var1, Attributes var2);

    public abstract void handleNameResolutionError(Status var1);

    public abstract void handleSubchannelState(Subchannel var1, ConnectivityStateInfo var2);

    public abstract void shutdown();

    @ThreadSafe
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
    public static abstract class Factory {
        public abstract LoadBalancer newLoadBalancer(Helper var1);
    }

    @ThreadSafe
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
    public static abstract class Subchannel {
        public abstract void shutdown();

        public abstract void requestConnection();

        public final EquivalentAddressGroup getAddresses() {
            List<EquivalentAddressGroup> groups = this.getAllAddresses();
            Preconditions.checkState(groups.size() == 1, "Does not have exactly one group");
            return groups.get(0);
        }

        public List<EquivalentAddressGroup> getAllAddresses() {
            throw new UnsupportedOperationException();
        }

        public abstract Attributes getAttributes();

        @Internal
        public Channel asChannel() {
            throw new UnsupportedOperationException();
        }

        public ChannelLogger getChannelLogger() {
            throw new UnsupportedOperationException();
        }
    }

    @ThreadSafe
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
    public static abstract class Helper {
        public final Subchannel createSubchannel(EquivalentAddressGroup addrs, Attributes attrs) {
            Preconditions.checkNotNull(addrs, "addrs");
            return this.createSubchannel(Collections.singletonList(addrs), attrs);
        }

        public Subchannel createSubchannel(List<EquivalentAddressGroup> addrs, Attributes attrs) {
            throw new UnsupportedOperationException();
        }

        public final void updateSubchannelAddresses(Subchannel subchannel, EquivalentAddressGroup addrs) {
            Preconditions.checkNotNull(addrs, "addrs");
            this.updateSubchannelAddresses(subchannel, Collections.singletonList(addrs));
        }

        public void updateSubchannelAddresses(Subchannel subchannel, List<EquivalentAddressGroup> addrs) {
            throw new UnsupportedOperationException();
        }

        public abstract ManagedChannel createOobChannel(EquivalentAddressGroup var1, String var2);

        public void updateOobChannelAddresses(ManagedChannel channel, EquivalentAddressGroup eag) {
            throw new UnsupportedOperationException();
        }

        public abstract void updateBalancingState(@Nonnull ConnectivityState var1, @Nonnull SubchannelPicker var2);

        @Deprecated
        public void runSerialized(Runnable task) {
            this.getSynchronizationContext().execute(task);
        }

        public SynchronizationContext getSynchronizationContext() {
            throw new UnsupportedOperationException();
        }

        public ScheduledExecutorService getScheduledExecutorService() {
            throw new UnsupportedOperationException();
        }

        public abstract NameResolver.Factory getNameResolverFactory();

        public abstract String getAuthority();

        public ChannelLogger getChannelLogger() {
            throw new UnsupportedOperationException();
        }
    }

    @Immutable
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
    public static final class PickResult {
        private static final PickResult NO_RESULT = new PickResult(null, null, Status.OK, false);
        @Nullable
        private final Subchannel subchannel;
        @Nullable
        private final ClientStreamTracer.Factory streamTracerFactory;
        private final Status status;
        private final boolean drop;

        private PickResult(@Nullable Subchannel subchannel, @Nullable ClientStreamTracer.Factory streamTracerFactory, Status status, boolean drop) {
            this.subchannel = subchannel;
            this.streamTracerFactory = streamTracerFactory;
            this.status = Preconditions.checkNotNull(status, "status");
            this.drop = drop;
        }

        public static PickResult withSubchannel(Subchannel subchannel, @Nullable ClientStreamTracer.Factory streamTracerFactory) {
            return new PickResult(Preconditions.checkNotNull(subchannel, "subchannel"), streamTracerFactory, Status.OK, false);
        }

        public static PickResult withSubchannel(Subchannel subchannel) {
            return PickResult.withSubchannel(subchannel, null);
        }

        public static PickResult withError(Status error) {
            Preconditions.checkArgument(!error.isOk(), "error status shouldn't be OK");
            return new PickResult(null, null, error, false);
        }

        public static PickResult withDrop(Status status) {
            Preconditions.checkArgument(!status.isOk(), "drop status shouldn't be OK");
            return new PickResult(null, null, status, true);
        }

        public static PickResult withNoResult() {
            return NO_RESULT;
        }

        @Nullable
        public Subchannel getSubchannel() {
            return this.subchannel;
        }

        @Nullable
        public ClientStreamTracer.Factory getStreamTracerFactory() {
            return this.streamTracerFactory;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isDrop() {
            return this.drop;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("subchannel", this.subchannel).add("streamTracerFactory", this.streamTracerFactory).add("status", this.status).add("drop", this.drop).toString();
        }

        public int hashCode() {
            return Objects.hashCode(this.subchannel, this.status, this.streamTracerFactory, this.drop);
        }

        public boolean equals(Object other) {
            if (!(other instanceof PickResult)) {
                return false;
            }
            PickResult that = (PickResult)other;
            return Objects.equal(this.subchannel, that.subchannel) && Objects.equal(this.status, that.status) && Objects.equal(this.streamTracerFactory, that.streamTracerFactory) && this.drop == that.drop;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
    public static abstract class PickSubchannelArgs {
        public abstract CallOptions getCallOptions();

        public abstract Metadata getHeaders();

        public abstract MethodDescriptor<?, ?> getMethodDescriptor();
    }

    @ThreadSafe
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
    public static abstract class SubchannelPicker {
        public abstract PickResult pickSubchannel(PickSubchannelArgs var1);

        public void requestConnection() {
        }
    }
}

