/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.shaded.io.grpc;

import io.etcd.jetcd.shaded.com.google.common.base.MoreObjects;
import io.etcd.jetcd.shaded.com.google.common.base.Preconditions;
import io.etcd.jetcd.shaded.io.grpc.Attributes;
import io.etcd.jetcd.shaded.io.grpc.CallCredentials;
import io.etcd.jetcd.shaded.io.grpc.ExperimentalApi;
import io.etcd.jetcd.shaded.io.grpc.Metadata;
import io.etcd.jetcd.shaded.io.grpc.MethodDescriptor;
import io.etcd.jetcd.shaded.io.grpc.SecurityLevel;
import io.etcd.jetcd.shaded.io.grpc.Status;
import java.util.concurrent.Executor;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4901")
public abstract class CallCredentials2
implements CallCredentials {
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1914")
    public abstract void applyRequestMetadata(CallCredentials.RequestInfo var1, Executor var2, MetadataApplier var3);

    @Override
    public final void applyRequestMetadata(final MethodDescriptor<?, ?> method, final Attributes attrs, Executor appExecutor, final CallCredentials.MetadataApplier applier) {
        final String authority = (String)Preconditions.checkNotNull(attrs.get(ATTR_AUTHORITY), "authority");
        final SecurityLevel securityLevel = MoreObjects.firstNonNull(attrs.get(ATTR_SECURITY_LEVEL), SecurityLevel.NONE);
        CallCredentials.RequestInfo requestInfo = new CallCredentials.RequestInfo(){

            @Override
            public MethodDescriptor<?, ?> getMethodDescriptor() {
                return method;
            }

            @Override
            public SecurityLevel getSecurityLevel() {
                return securityLevel;
            }

            @Override
            public String getAuthority() {
                return authority;
            }

            @Override
            public Attributes getTransportAttrs() {
                return attrs;
            }
        };
        MetadataApplier applierAdapter = new MetadataApplier(){

            @Override
            public void apply(Metadata headers) {
                applier.apply(headers);
            }

            @Override
            public void fail(Status status) {
                applier.fail(status);
            }
        };
        this.applyRequestMetadata(requestInfo, appExecutor, applierAdapter);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1914")
    public static abstract class MetadataApplier
    implements CallCredentials.MetadataApplier {
    }
}

