/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.op;

import io.etcd.jetcd.Txn;
import io.etcd.jetcd.api.TxnRequest;
import io.etcd.jetcd.kv.TxnResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.Op;
import io.etcd.jetcd.shaded.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TxnImpl
implements Txn {
    private List<Cmp> cmpList = new ArrayList<Cmp>();
    private List<Op> successOpList = new ArrayList<Op>();
    private List<Op> failureOpList = new ArrayList<Op>();
    private Function<TxnRequest, CompletableFuture<TxnResponse>> requestF;
    private boolean seenThen = false;
    private boolean seenElse = false;

    public static TxnImpl newTxn(Function<TxnRequest, CompletableFuture<TxnResponse>> f) {
        return new TxnImpl(f);
    }

    private TxnImpl(Function<TxnRequest, CompletableFuture<TxnResponse>> f) {
        this.requestF = f;
    }

    @Override
    public TxnImpl If(Cmp ... cmps) {
        return this.If(ImmutableList.copyOf(cmps));
    }

    TxnImpl If(List<Cmp> cmps) {
        if (this.seenThen) {
            throw new IllegalArgumentException("cannot call If after Then!");
        }
        if (this.seenElse) {
            throw new IllegalArgumentException("cannot call If after Else!");
        }
        this.cmpList.addAll(cmps);
        return this;
    }

    @Override
    public TxnImpl Then(Op ... ops) {
        return this.Then(ImmutableList.copyOf(ops));
    }

    TxnImpl Then(List<Op> ops) {
        if (this.seenElse) {
            throw new IllegalArgumentException("cannot call Then after Else!");
        }
        this.seenThen = true;
        this.successOpList.addAll(ops);
        return this;
    }

    @Override
    public TxnImpl Else(Op ... ops) {
        return this.Else(ImmutableList.copyOf(ops));
    }

    TxnImpl Else(List<Op> ops) {
        this.seenElse = true;
        this.failureOpList.addAll(ops);
        return this;
    }

    @Override
    public CompletableFuture<TxnResponse> commit() {
        return this.requestF.apply(this.toTxnRequest());
    }

    private TxnRequest toTxnRequest() {
        TxnRequest.Builder requestBuilder = TxnRequest.newBuilder();
        for (Cmp c : this.cmpList) {
            requestBuilder.addCompare(c.toCompare());
        }
        for (Op o : this.successOpList) {
            requestBuilder.addSuccess(o.toRequestOp());
        }
        for (Op o : this.failureOpList) {
            requestBuilder.addFailure(o.toRequestOp());
        }
        return requestBuilder.build();
    }
}

