/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.Commands;
import io.ebean.docker.commands.DbContainer;
import io.ebean.docker.commands.HanaConfig;
import io.ebean.docker.container.Container;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaContainer
extends DbContainer
implements Container {
    private static final Logger log = LoggerFactory.getLogger(Commands.class);
    private final HanaConfig hanaConfig;

    public static HanaContainer create(String version, Properties properties) {
        return new HanaContainer(new HanaConfig(version, properties));
    }

    public HanaContainer(HanaConfig config) {
        super(config);
        this.hanaConfig = config;
        String osName = System.getProperty("os.name").toLowerCase();
        if (!osName.contains("linux")) {
            throw new IllegalStateException("The HANA docker image requires a Linux operating system");
        }
        if (!this.hanaConfig.isAgreeToSapLicense()) {
            throw new IllegalStateException("You must agree to the SAP license (https://www.sap.com/docs/download/cmp/2016/06/sap-hana-express-dev-agmt-and-exhibit.pdf) by setting the property 'hana.agreeToSapLicense' to 'true'");
        }
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return this.isDatabaseReady();
    }

    @Override
    protected boolean isDatabaseReady() {
        return this.commands.logsContain(this.config.containerName(), "Startup finished!");
    }

    @Override
    public boolean startWithCreate() {
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        if (!this.createUserIfNotExists()) {
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    public boolean startWithDropCreate() {
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        this.dropUserIfExists();
        if (!this.createUserIfNotExists()) {
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("run");
        args.add("-d");
        args.add("-p");
        args.add("3" + this.hanaConfig.getInstanceNumber() + "13:39013");
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add("-p");
        args.add("3" + this.hanaConfig.getInstanceNumber() + "41-3" + this.hanaConfig.getInstanceNumber() + "45:39041-39045");
        args.add("-v");
        args.add(this.hanaConfig.getMountsDirectory() + ":/hana/mounts");
        args.add("--ulimit");
        args.add("nofile=1048576:1048576");
        args.add("--sysctl");
        args.add("kernel.shmmax=1073741824");
        args.add("--sysctl");
        args.add("kernel.shmmni=524288");
        args.add("--sysctl");
        args.add("kernel.shmall=8388608");
        args.add("--name");
        args.add(this.config.containerName());
        args.add(this.config.getImage());
        args.add("--passwords-url");
        args.add(this.hanaConfig.getPasswordsUrl().toString());
        if (this.hanaConfig.isAgreeToSapLicense()) {
            args.add("--agree-to-sap-license");
        }
        return this.createProcessBuilder(args);
    }

    private boolean dropUserIfExists() {
        log.info("Drop database user {} if exists", (Object)this.dbConfig.getUsername());
        this.sqlProcess(connection -> {
            if (this.userExists((Connection)connection)) {
                this.sqlRun((Connection)connection, "drop user " + this.dbConfig.getUsername() + " cascade");
            }
        });
        return true;
    }

    private boolean createUserIfNotExists() {
        log.info("Create database user {} if not exists", (Object)this.dbConfig.getUsername());
        this.sqlProcess(connection -> {
            if (!this.userExists((Connection)connection)) {
                this.sqlRun((Connection)connection, "create user " + this.dbConfig.getUsername() + " password " + this.dbConfig.getPassword() + " no force_first_password_change");
            }
        });
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean userExists(Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement("select count(*) from sys.users where user_name = upper(?)");){
            boolean bl;
            block18: {
                ResultSet rs;
                block16: {
                    boolean bl2;
                    block17: {
                        statement.setString(1, this.dbConfig.getUsername());
                        rs = statement.executeQuery();
                        try {
                            if (!rs.next()) break block16;
                            int count = rs.getInt(1);
                            boolean bl3 = bl2 = count == 1;
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl2;
                }
                bl = false;
                if (rs == null) break block18;
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            log.error("Failed to execute sql to check if user exists", (Throwable)e);
            return false;
        }
    }

    private <E extends Throwable> void sneakyThrow(Throwable t) throws E {
        throw t;
    }
}

