/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseDbBuilder;
import io.ebean.test.containers.BasePostgresContainer;
import java.util.ArrayList;

public class YugabyteContainer
extends BasePostgresContainer<YugabyteContainer> {
    protected final Builder builder;

    @Override
    public YugabyteContainer start() {
        this.startOrThrow();
        return this;
    }

    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return YugabyteContainer.builder(version);
    }

    private YugabyteContainer(Builder builder) {
        super(builder);
        this.builder = builder;
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add("-p");
        args.add(this.builder.port7000 + ":7000");
        args.add("-p");
        args.add(this.builder.port9000 + ":9000");
        args.add("-p");
        args.add(this.builder.port9042 + ":9042");
        args.add(this.config.getImage());
        args.add("bin/yugabyted");
        args.add("start");
        args.add("--daemon=false");
        return this.createProcessBuilder(args);
    }

    public static class Builder
    extends BaseDbBuilder<YugabyteContainer, Builder> {
        int port9042 = 9042;
        int port9000 = 9000;
        int port7000 = 7000;

        private Builder(String version) {
            super("yugabyte", 6433, 5433, version);
            this.image = "yugabytedb/yugabyte:" + version;
            this.adminUsername = "postgres";
        }

        public Builder port7000(int port7000) {
            this.port7000 = port7000;
            return (Builder)this.self();
        }

        public Builder port9000(int port9000) {
            this.port9000 = port9000;
            return (Builder)this.self();
        }

        public Builder port9042(int port9042) {
            this.port9042 = port9042;
            return (Builder)this.self();
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:postgresql://" + this.getHost() + ":" + this.getPort() + "/" + this.getDbName();
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return "jdbc:postgresql://" + this.getHost() + ":" + this.getPort() + "/postgres";
        }

        @Override
        public YugabyteContainer build() {
            return new YugabyteContainer(this);
        }

        @Override
        public YugabyteContainer start() {
            return this.build().start();
        }
    }
}

