/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseDbBuilder;
import io.ebean.test.containers.DbContainer;
import java.sql.Connection;

abstract class BaseJdbcContainer<C extends BaseJdbcContainer<C>>
extends DbContainer<C> {
    BaseJdbcContainer(BaseDbBuilder<?, ?> config) {
        super(config);
        this.checkConnectivityUsingAdmin = true;
    }

    abstract void createDatabase();

    abstract void dropCreateDatabase();

    @Override
    public boolean startWithCreate() {
        if (!this.startContainerWithWait()) {
            return false;
        }
        this.createDatabase();
        return true;
    }

    @Override
    public boolean startWithDropCreate() {
        if (!this.startContainerWithWait()) {
            return false;
        }
        this.dropCreateDatabase();
        return true;
    }

    private boolean startContainerWithWait() {
        if (this.checkAlreadyRunning()) {
            return true;
        }
        this.startIfNeeded();
        if (!this.waitForConnectivity()) {
            log.log(System.Logger.Level.WARNING, "Failed waiting for connectivity");
            return false;
        }
        return true;
    }

    protected boolean checkAlreadyRunning() {
        boolean bl;
        block9: {
            if (this.dbConfig.randomPort()) {
                return false;
            }
            Connection connection = this.dbConfig.createAdminConnection();
            try {
                bl = true;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    @Override
    public boolean waitForDatabaseReady() {
        return true;
    }

    @Override
    protected boolean isDatabaseReady() {
        return true;
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return true;
    }
}

