/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.postgis;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import java.io.DataInput;
import java.io.DataOutput;
import java.sql.SQLException;
import org.postgis.Geometry;
import org.postgis.GeometryBuilder;
import org.postgis.PGgeometry;
import org.postgis.PGgeometryLW;
import org.postgis.binary.BinaryParser;
import org.postgresql.util.PGobject;

abstract class ScalarTypePgisBase<T extends Geometry>
implements ScalarType<T> {
    private final int jdbcType;
    private final Class<T> cls;

    ScalarTypePgisBase(int jdbcType, Class<T> cls) {
        this.jdbcType = jdbcType;
        this.cls = cls;
    }

    public void bind(DataBinder binder, T value) throws SQLException {
        if (value == null) {
            binder.setNull(0);
        } else {
            binder.setObject((Object)new PGgeometryLW(value));
        }
    }

    public T read(DataReader reader) throws SQLException {
        Object object = reader.getObject();
        if (object == null) {
            return null;
        }
        if (object instanceof PGgeometryLW) {
            return (T)((PGgeometryLW)object).getGeometry();
        }
        if (object instanceof PGgeometry) {
            return (T)((PGgeometry)object).getGeometry();
        }
        if (object instanceof PGobject) {
            return (T)GeometryBuilder.geomFromString((String)((PGobject)object).getValue(), (BinaryParser)new BinaryParser(), (boolean)false);
        }
        throw new IllegalStateException("Could not convert from " + object.getClass() + " to " + this.cls);
    }

    public boolean isJdbcNative() {
        return true;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public Class<T> getType() {
        return this.cls;
    }

    public T readData(DataInput dataInput) {
        return null;
    }

    public void writeData(DataOutput dataOutput, T v) {
    }

    public boolean isBinaryType() {
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isDirty(Object value) {
        return false;
    }

    public int getLength() {
        return 0;
    }

    public void loadIgnore(DataReader reader) {
        reader.incrementPos(1);
    }

    public Object toJdbcType(Object value) {
        return null;
    }

    public T toBeanType(Object value) {
        return null;
    }

    public String formatValue(T value) {
        return null;
    }

    public String format(Object value) {
        return null;
    }

    public T parse(String value) {
        return null;
    }

    public DocPropertyType getDocType() {
        return null;
    }

    public boolean isDateTimeCapable() {
        return false;
    }

    public long asVersion(T value) {
        return 0L;
    }

    public T convertFromMillis(long dateTime) {
        return null;
    }

    public T jsonRead(JsonParser parser) {
        return null;
    }

    public void jsonWrite(JsonGenerator writer, T value) {
    }
}

