/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration;

import io.ebean.migration.DbNameUtil;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationException;
import io.ebean.migration.runner.LocalMigrationResource;
import io.ebean.migration.runner.LocalMigrationResources;
import io.ebean.migration.runner.MigrationPlatform;
import io.ebean.migration.runner.MigrationSchema;
import io.ebean.migration.runner.MigrationTable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationRunner {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRunner.class);
    protected final MigrationConfig migrationConfig;
    protected List<LocalMigrationResource> checkMigrations;

    public MigrationRunner(MigrationConfig migrationConfig) {
        this.migrationConfig = migrationConfig;
    }

    @Nonnull
    public List<LocalMigrationResource> checkState() {
        return this.checkState(this.migrationConfig.createConnection());
    }

    @Nonnull
    public List<LocalMigrationResource> checkState(DataSource dataSource) {
        return this.checkState(this.getConnection(dataSource));
    }

    @Nonnull
    public List<LocalMigrationResource> checkState(Connection connection) {
        this.run(connection, true);
        return this.checkMigrations;
    }

    public void run() {
        this.run(this.migrationConfig.createConnection());
    }

    public void run(DataSource dataSource) {
        this.run(this.getConnection(dataSource));
    }

    public void run(Connection connection) {
        this.run(connection, false);
    }

    private Connection getConnection(DataSource dataSource) {
        String username = this.migrationConfig.getDbUsername();
        try {
            if (username == null) {
                return dataSource.getConnection();
            }
            logger.debug("using db user [{}] to run migrations ...", (Object)username);
            return dataSource.getConnection(username, this.migrationConfig.getDbPassword());
        }
        catch (SQLException e) {
            String msgSuffix = username == null ? "" : " using user [" + username + "]";
            throw new IllegalArgumentException("Error trying to connect to database for DB Migration" + msgSuffix, e);
        }
    }

    protected void run(Connection connection, boolean checkStateMode) {
        LocalMigrationResources resources = new LocalMigrationResources(this.migrationConfig);
        if (!resources.readResources()) {
            logger.debug("no migrations to check");
            return;
        }
        try {
            connection.setAutoCommit(false);
            MigrationPlatform platform = this.derivePlatformName(this.migrationConfig, connection);
            new MigrationSchema(this.migrationConfig, connection).createAndSetIfNeeded();
            MigrationTable table = new MigrationTable(this.migrationConfig, connection, checkStateMode, platform);
            table.createIfNeededAndLock();
            this.runMigrations(resources, table, checkStateMode);
            connection.commit();
            table.runNonTransactional();
        }
        catch (MigrationException e) {
            this.rollback(connection);
            throw e;
        }
        catch (Exception e) {
            this.rollback(connection);
            throw new RuntimeException(e);
        }
        finally {
            this.close(connection);
        }
    }

    private void runMigrations(LocalMigrationResources resources, MigrationTable table, boolean checkStateMode) throws SQLException {
        LocalMigrationResource initVersion;
        List<LocalMigrationResource> localVersions = resources.getVersions();
        if (table.isEmpty() && (initVersion = this.getInitVersion()) != null) {
            logger.info("dbinit migration version:{}  local migrations:{}  checkState:{}", new Object[]{initVersion, localVersions.size(), checkStateMode});
            this.checkMigrations = table.runInit(initVersion, localVersions);
            return;
        }
        logger.info("local migrations:{}  existing migrations:{}  checkState:{}", new Object[]{localVersions.size(), table.size(), checkStateMode});
        this.checkMigrations = table.runAll(localVersions);
    }

    private LocalMigrationResource getInitVersion() {
        List<LocalMigrationResource> initVersions;
        LocalMigrationResources initResources = new LocalMigrationResources(this.migrationConfig);
        if (initResources.readInitResources() && !(initVersions = initResources.getVersions()).isEmpty()) {
            return initVersions.get(initVersions.size() - 1);
        }
        return null;
    }

    private MigrationPlatform derivePlatformName(MigrationConfig migrationConfig, Connection connection) {
        String platform = migrationConfig.getPlatform();
        if (platform != null) {
            return DbNameUtil.platform(platform);
        }
        String platformName = migrationConfig.getPlatformName();
        if (platformName == null) {
            platformName = DbNameUtil.normalise(connection);
            migrationConfig.setPlatformName(platformName);
        }
        return DbNameUtil.platform(platformName);
    }

    private void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            logger.warn("Error closing connection", (Throwable)e);
        }
    }

    private void rollback(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            logger.warn("Error on connection rollback", (Throwable)e);
        }
    }
}

