/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.ddlrunner;

import io.ebean.ddlrunner.DdlAutoCommit;
import io.ebean.ddlrunner.DdlRunnerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class DdlParser {
    private final DdlAutoCommit ddlAutoCommit;
    private final StatementsSeparator parse = new StatementsSeparator();
    private final List<String> statements = new ArrayList<String>();
    private final List<String> statementsNonTrans = new ArrayList<String>();

    public DdlParser(DdlAutoCommit ddlAutoCommit) {
        this.ddlAutoCommit = ddlAutoCommit;
    }

    void push(String sql) {
        if (this.ddlAutoCommit.transactional(sql)) {
            this.statements.add(sql);
        } else {
            this.statementsNonTrans.add(sql);
        }
    }

    public List<String> parse(Reader reader) {
        try {
            String s;
            BufferedReader br = new BufferedReader(reader);
            while ((s = br.readLine()) != null) {
                this.parse.nextLine(s);
            }
            this.parse.endOfContent();
            return this.statements;
        }
        catch (IOException e) {
            throw new DdlRunnerException(e);
        }
    }

    public List<String> getNonTransactional() {
        return this.statementsNonTrans;
    }

    class StatementsSeparator {
        private static final String EOL = "\n";
        private static final String GO = "GO";
        private static final String PROCEDURE = " PROCEDURE ";
        private boolean trimDelimiter;
        private boolean inDbProcedure;
        private StringBuilder sb = new StringBuilder();
        private int lineCount;
        private int quoteCount;

        StatementsSeparator() {
        }

        void lineContainsDollars(String line) {
            if (this.inDbProcedure) {
                if (this.trimDelimiter) {
                    line = line.replace("$$", "");
                }
                this.endOfStatement(line);
            } else {
                this.trimDelimiter = line.equals("delimiter $$");
                if (!this.trimDelimiter) {
                    this.sb.append(line).append(EOL);
                }
                this.inDbProcedure = true;
            }
        }

        void endOfStatement(String line) {
            this.sb.append(line);
            DdlParser.this.push(this.sb.toString().trim());
            this.newBuffer();
        }

        private void newBuffer() {
            this.quoteCount = 0;
            this.lineCount = 0;
            this.inDbProcedure = false;
            this.sb = new StringBuilder();
        }

        void nextLine(String line) {
            if (line.trim().equals(GO)) {
                this.endOfStatement("");
                return;
            }
            if (line.contains("$$")) {
                this.lineContainsDollars(line);
                return;
            }
            if (this.inDbProcedure) {
                this.sb.append(line).append(EOL);
                return;
            }
            if (this.sb.length() == 0 && (line.isEmpty() || line.startsWith("--"))) {
                return;
            }
            if (this.lineCount == 0 && this.isStartDbProcedure(line)) {
                this.inDbProcedure = true;
            }
            ++this.lineCount;
            this.quoteCount += this.countQuotes(line);
            if (this.hasOddQuotes()) {
                this.sb.append(line).append(EOL);
                return;
            }
            int semiPos = line.lastIndexOf(59);
            if (semiPos == -1) {
                this.sb.append(line).append(EOL);
            } else if (semiPos == line.length() - 1) {
                this.endOfStatement(line);
            } else {
                String remaining = line.substring(semiPos + 1).trim();
                if (!remaining.startsWith("--")) {
                    this.sb.append(line).append(EOL);
                    return;
                }
                String preSemi = line.substring(0, semiPos + 1);
                this.endOfStatement(preSemi);
            }
        }

        private boolean isStartDbProcedure(String line) {
            return line.length() > 26 && line.substring(0, 26).toUpperCase().contains(PROCEDURE);
        }

        private boolean hasOddQuotes() {
            return this.quoteCount % 2 == 1;
        }

        private int countQuotes(String content) {
            int count = 0;
            for (int i = 0; i < content.length(); ++i) {
                if (content.charAt(i) != '\'') continue;
                ++count;
            }
            return count;
        }

        void endOfContent() {
            String remaining = this.sb.toString().trim();
            if (remaining.length() > 0) {
                DdlParser.this.push(remaining);
                this.newBuffer();
            }
        }
    }
}

