/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.migrationreader;

import io.ebean.util.IOUtils;
import io.ebeaninternal.dbmigration.migration.Migration;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public class MigrationXmlWriter {
    private final String comment;

    public MigrationXmlWriter(String comment) {
        this.comment = comment;
    }

    public void write(Migration migration, File file) {
        try (BufferedWriter writer = IOUtils.newWriter((File)file);){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            if (this.comment != null) {
                writer.write("<!-- ");
                writer.write(this.comment);
                writer.write(" -->\n");
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Migration.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal((Object)migration, (Writer)writer);
        }
        catch (JAXBException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

