/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.ConstraintMode;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.SplitColumns;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.AlterForeignKey;
import io.ebeaninternal.dbmigration.migration.Column;
import io.ebeaninternal.dbmigration.migration.ForeignKey;

class WriteForeignKey {
    private final String fkName;
    private final String tableName;
    private final String[] cols;
    private String refTableName;
    private String[] refCols;
    private final String indexName;
    private final ConstraintMode onDelete;
    private final ConstraintMode onUpdate;

    WriteForeignKey(AlterColumn alterColumn) {
        this.tableName = alterColumn.getTableName();
        this.indexName = alterColumn.getForeignKeyIndex();
        this.fkName = alterColumn.getForeignKeyName();
        this.cols = new String[]{alterColumn.getColumnName()};
        this.setReferences(alterColumn.getReferences());
        this.onDelete = this.modeOf(alterColumn.getForeignKeyOnDelete());
        this.onUpdate = this.modeOf(alterColumn.getForeignKeyOnUpdate());
    }

    WriteForeignKey(String tableName, ForeignKey key) {
        this.tableName = tableName;
        this.indexName = key.getIndexName();
        this.fkName = key.getName();
        this.cols = this.toCols(key.getColumnNames());
        this.refTableName = key.getRefTableName();
        this.refCols = this.toCols(key.getRefColumnNames());
        this.onDelete = this.modeOf(key.getOnDelete());
        this.onUpdate = this.modeOf(key.getOnUpdate());
    }

    WriteForeignKey(AlterForeignKey key) {
        this.tableName = key.getTableName();
        this.indexName = key.getIndexName();
        this.fkName = key.getName();
        this.cols = this.toCols(key.getColumnNames());
        this.refTableName = key.getRefTableName();
        this.refCols = this.toCols(key.getRefColumnNames());
        this.onDelete = this.modeOf(key.getOnDelete());
        this.onUpdate = this.modeOf(key.getOnUpdate());
    }

    WriteForeignKey(String tableName, Column column) {
        this.tableName = tableName;
        this.indexName = column.getForeignKeyIndex();
        this.fkName = column.getForeignKeyName();
        this.cols = new String[]{column.getName()};
        this.setReferences(column.getReferences());
        this.onDelete = this.modeOf(column.getForeignKeyOnDelete());
        this.onUpdate = this.modeOf(column.getForeignKeyOnUpdate());
    }

    private void setReferences(String references) {
        int pos = references.lastIndexOf(46);
        if (pos == -1) {
            throw new IllegalStateException("Expecting period '.' character for table.column split but not found in [" + references + "]");
        }
        this.refTableName = references.substring(0, pos);
        String refColumnName = references.substring(pos + 1);
        this.refCols = new String[]{refColumnName};
    }

    private String[] toCols(String columns) {
        return SplitColumns.split(columns);
    }

    private ConstraintMode modeOf(String value) {
        return value == null ? null : ConstraintMode.valueOf((String)value);
    }

    public String table() {
        return this.tableName;
    }

    public String[] cols() {
        return this.cols;
    }

    public String indexName() {
        return this.indexName;
    }

    public String fkName() {
        return this.fkName;
    }

    public String refTable() {
        return this.refTableName;
    }

    public String[] refCols() {
        return this.refCols;
    }

    public ConstraintMode onDelete() {
        return this.onDelete;
    }

    public ConstraintMode onUpdate() {
        return this.onUpdate;
    }
}

