/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.IdentityGenerated;
import io.ebean.config.dbplatform.IdType;
import io.ebeaninternal.server.deploy.IdentityMode;

public class DdlIdentity {
    public static final DdlIdentity NONE = new DdlIdentity();
    private final IdType idType;
    private final IdentityMode identityMode;
    private final String sequenceName;

    public DdlIdentity(IdType idType, IdentityMode identityMode, String sequenceName) {
        this.idType = idType;
        this.identityMode = identityMode;
        this.sequenceName = sequenceName;
    }

    private DdlIdentity() {
        this.idType = null;
        this.identityMode = null;
        this.sequenceName = null;
    }

    public boolean useSequence() {
        return this.idType == IdType.SEQUENCE;
    }

    public boolean useIdentity() {
        return this.idType == IdType.IDENTITY;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    private String generatedBy() {
        return this.isAlways() ? "always" : "by default";
    }

    private boolean isAlways() {
        return IdentityGenerated.ALWAYS == this.identityMode.getGenerated();
    }

    public String optionGenerated() {
        return " generated " + this.generatedBy() + " as identity";
    }

    public String identityOptions(String startWith, String incrementBy, String cache) {
        return this.options(true, startWith, incrementBy, cache);
    }

    public String sequenceOptions(String startWith, String incrementBy, String cache) {
        return this.options(false, startWith, incrementBy, cache);
    }

    private String options(boolean brackets, String startWith, String incrementBy, String cache) {
        if (!this.identityMode.hasOptions()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(40);
        if (brackets) {
            sb.append(" (");
        } else {
            sb.append(" ");
        }
        this.optionFor(sb, startWith, this.identityMode.getStart());
        this.optionFor(sb, incrementBy, this.identityMode.getIncrement());
        this.optionFor(sb, cache, this.identityMode.getCache());
        if (brackets) {
            sb.append(")");
        }
        return sb.toString();
    }

    private void optionFor(StringBuilder sb, String prefix, int val) {
        if (val > 0 && prefix != null) {
            if (sb.length() > 2) {
                sb.append(" ");
            }
            sb.append(prefix).append(" ").append(val);
        }
    }

    public int getStart() {
        return this.identityMode.getStart();
    }

    public int getIncrement() {
        return this.identityMode.getIncrement();
    }

    public int getCache() {
        return this.identityMode.getCache();
    }
}

