/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration;

import io.ebean.config.DatabaseConfig;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.TableDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseTableDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.AddColumn;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AddTableComment;
import io.ebeaninternal.dbmigration.migration.AddUniqueConstraint;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.AlterForeignKey;
import io.ebeaninternal.dbmigration.migration.ChangeSet;
import io.ebeaninternal.dbmigration.migration.CreateIndex;
import io.ebeaninternal.dbmigration.migration.CreateTable;
import io.ebeaninternal.dbmigration.migration.DropColumn;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropIndex;
import io.ebeaninternal.dbmigration.migration.DropTable;
import java.io.IOException;
import java.util.List;

public class BaseDdlHandler
implements DdlHandler {
    protected final TableDdl tableDdl;

    public BaseDdlHandler(DatabaseConfig config, PlatformDdl platformDdl) {
        this(config, platformDdl, new BaseTableDdl(config, platformDdl));
    }

    protected BaseDdlHandler(DatabaseConfig config, PlatformDdl platformDdl, TableDdl tableDdl) {
        this.tableDdl = tableDdl;
    }

    @Override
    public void generate(DdlWrite writer, ChangeSet changeSet) throws IOException {
        List<Object> changeSetChildren = changeSet.getChangeSetChildren();
        for (Object change : changeSetChildren) {
            if (!(change instanceof CreateTable)) continue;
            this.generate(writer, (CreateTable)change);
        }
        for (Object change : changeSetChildren) {
            if (change instanceof CreateTable) continue;
            if (change instanceof DropTable) {
                this.generate(writer, (DropTable)change);
                continue;
            }
            if (change instanceof AddTableComment) {
                this.generate(writer, (AddTableComment)change);
                continue;
            }
            if (change instanceof CreateIndex) {
                this.generate(writer, (CreateIndex)change);
                continue;
            }
            if (change instanceof DropIndex) {
                this.generate(writer, (DropIndex)change);
                continue;
            }
            if (change instanceof AddColumn) {
                this.generate(writer, (AddColumn)change);
                continue;
            }
            if (change instanceof DropColumn) {
                this.generate(writer, (DropColumn)change);
                continue;
            }
            if (change instanceof AlterColumn) {
                this.generate(writer, (AlterColumn)change);
                continue;
            }
            if (change instanceof AddHistoryTable) {
                this.generate(writer, (AddHistoryTable)change);
                continue;
            }
            if (change instanceof DropHistoryTable) {
                this.generate(writer, (DropHistoryTable)change);
                continue;
            }
            if (change instanceof AddUniqueConstraint) {
                this.generate(writer, (AddUniqueConstraint)change);
                continue;
            }
            if (change instanceof AlterForeignKey) {
                this.generate(writer, (AlterForeignKey)change);
                continue;
            }
            throw new IllegalArgumentException("Unsupported change: " + change);
        }
    }

    @Override
    public void generateProlog(DdlWrite write) throws IOException {
        this.tableDdl.generateProlog(write);
    }

    @Override
    public void generateEpilog(DdlWrite write) throws IOException {
        this.tableDdl.generateEpilog(write);
    }

    @Override
    public void generate(DdlWrite writer, CreateTable createTable) throws IOException {
        this.tableDdl.generate(writer, createTable);
    }

    @Override
    public void generate(DdlWrite writer, DropTable dropTable) throws IOException {
        this.tableDdl.generate(writer, dropTable);
    }

    @Override
    public void generate(DdlWrite writer, AddTableComment addTableComment) throws IOException {
        this.tableDdl.generate(writer, addTableComment);
    }

    @Override
    public void generate(DdlWrite writer, AddColumn addColumn) throws IOException {
        this.tableDdl.generate(writer, addColumn);
    }

    @Override
    public void generate(DdlWrite writer, DropColumn dropColumn) throws IOException {
        this.tableDdl.generate(writer, dropColumn);
    }

    @Override
    public void generate(DdlWrite writer, AlterColumn alterColumn) throws IOException {
        this.tableDdl.generate(writer, alterColumn);
    }

    @Override
    public void generate(DdlWrite writer, AddHistoryTable addHistoryTable) throws IOException {
        this.tableDdl.generate(writer, addHistoryTable);
    }

    @Override
    public void generate(DdlWrite writer, DropHistoryTable dropHistoryTable) throws IOException {
        this.tableDdl.generate(writer, dropHistoryTable);
    }

    @Override
    public void generate(DdlWrite writer, CreateIndex createIndex) throws IOException {
        this.tableDdl.generate(writer, createIndex);
    }

    @Override
    public void generate(DdlWrite writer, DropIndex dropIndex) throws IOException {
        this.tableDdl.generate(writer, dropIndex);
    }

    @Override
    public void generate(DdlWrite writer, AddUniqueConstraint constraint) throws IOException {
        this.tableDdl.generate(writer, constraint);
    }

    @Override
    public void generate(DdlWrite writer, AlterForeignKey alterForeignKey) throws IOException {
        this.tableDdl.generate(writer, alterForeignKey);
    }
}

