/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource;

import io.ebean.datasource.DataSourceConfig;
import io.ebean.datasource.InitDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresInitDatabase
implements InitDatabase {
    private static final Logger log = LoggerFactory.getLogger(PostgresInitDatabase.class);

    @Override
    public void run(Connection connection, DataSourceConfig config) throws SQLException {
        String username = config.getUsername();
        String password = config.getPassword();
        log.info("Creating schema and role for {}", (Object)username);
        this.execute(connection, String.format("create schema if not exists %s", username));
        this.execute(connection, String.format("create role %s with login password '%s'", username, password));
        this.execute(connection, String.format("grant all on schema %s to %s", username, username));
    }

    private void execute(Connection connection, String sql) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.execute();
        }
    }
}

