/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;

@JsonTypeName(value="quantiles")
public class Quantiles {
    float[] probabilities;
    float[] quantiles;
    float min;
    float max;

    @JsonCreator
    public Quantiles(@JsonProperty(value="probabilities") float[] probabilities, @JsonProperty(value="quantiles") float[] quantiles, @JsonProperty(value="min") float min, @JsonProperty(value="max") float max) {
        this.probabilities = probabilities;
        this.quantiles = quantiles;
        this.min = min;
        this.max = max;
    }

    @JsonProperty
    public float[] getProbabilities() {
        return this.probabilities;
    }

    @JsonProperty
    public float[] getQuantiles() {
        return this.quantiles;
    }

    @JsonProperty
    public float getMin() {
        return this.min;
    }

    @JsonProperty
    public float getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quantiles quantiles1 = (Quantiles)o;
        if (Float.compare(quantiles1.max, this.max) != 0) {
            return false;
        }
        if (Float.compare(quantiles1.min, this.min) != 0) {
            return false;
        }
        if (!Arrays.equals(this.probabilities, quantiles1.probabilities)) {
            return false;
        }
        return Arrays.equals(this.quantiles, quantiles1.quantiles);
    }

    public int hashCode() {
        int result = this.probabilities != null ? Arrays.hashCode(this.probabilities) : 0;
        result = 31 * result + (this.quantiles != null ? Arrays.hashCode(this.quantiles) : 0);
        result = 31 * result + (this.min != 0.0f ? Float.floatToIntBits(this.min) : 0);
        result = 31 * result + (this.max != 0.0f ? Float.floatToIntBits(this.max) : 0);
        return result;
    }
}

