/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import com.metamx.common.IAE;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

@JsonTypeName(value="quantile")
public class QuantilePostAggregator
extends ApproximateHistogramPostAggregator {
    static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Double.compare(((Number)o).doubleValue(), ((Number)o1).doubleValue());
        }
    };
    private final float probability;
    private String fieldName;

    @JsonCreator
    public QuantilePostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="probability") float probability) {
        super(name, fieldName);
        this.probability = probability;
        this.fieldName = fieldName;
        if (probability < 0.0f | probability > 1.0f) {
            throw new IAE("Illegal probability[%s], must be strictly between 0 and 1", new Object[]{Float.valueOf(probability)});
        }
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        ApproximateHistogram ah = (ApproximateHistogram)values.get(this.getFieldName());
        return Float.valueOf(ah.getQuantiles(new float[]{this.getProbability()})[0]);
    }

    @JsonProperty
    public float getProbability() {
        return this.probability;
    }

    @Override
    public String toString() {
        return "QuantilePostAggregator{probability=" + this.probability + ", fieldName='" + this.fieldName + '\'' + '}';
    }
}

