/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

@JsonTypeName(value="customBuckets")
public class CustomBucketsPostAggregator
extends ApproximateHistogramPostAggregator {
    private final float[] breaks;
    private String fieldName;

    @JsonCreator
    public CustomBucketsPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="breaks") float[] breaks) {
        super(name, fieldName);
        this.breaks = breaks;
        this.fieldName = fieldName;
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        ApproximateHistogram ah = (ApproximateHistogram)values.get(this.getFieldName());
        return ah.toHistogram(this.breaks);
    }

    @JsonProperty
    public float[] getBreaks() {
        return this.breaks;
    }

    @Override
    public String toString() {
        return "CustomBucketsPostAggregator{name='" + this.getName() + '\'' + ", fieldName='" + this.getFieldName() + '\'' + ", breaks=" + Arrays.toString(this.getBreaks()) + '}';
    }
}

