/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class BufferUtils {
    public static int binarySearch(DoubleBuffer buf, int minIndex, int maxIndex, double value) {
        while (minIndex < maxIndex) {
            int currIndex = minIndex + maxIndex - 1 >>> 1;
            double currValue = buf.get(currIndex);
            int comparison = Double.compare(currValue, value);
            if (comparison == 0) {
                return currIndex;
            }
            if (comparison < 0) {
                minIndex = currIndex + 1;
                continue;
            }
            maxIndex = currIndex;
        }
        return -(minIndex + 1);
    }

    public static int binarySearch(FloatBuffer buf, int minIndex, int maxIndex, float value) {
        while (minIndex < maxIndex) {
            int currIndex = minIndex + maxIndex - 1 >>> 1;
            float currValue = buf.get(currIndex);
            int comparison = Float.compare(currValue, value);
            if (comparison == 0) {
                return currIndex;
            }
            if (comparison < 0) {
                minIndex = currIndex + 1;
                continue;
            }
            maxIndex = currIndex;
        }
        return -(minIndex + 1);
    }
}

