/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.metamx.common.IAE;
import com.metamx.common.StringUtils;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramAggregatorFactory;
import io.druid.query.aggregation.histogram.ApproximateHistogramFoldingAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogramFoldingBufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ObjectColumnSelector;
import java.nio.ByteBuffer;

@JsonTypeName(value="approxHistogramFold")
public class ApproximateHistogramFoldingAggregatorFactory
extends ApproximateHistogramAggregatorFactory {
    private static final byte CACHE_TYPE_ID = 13;

    @JsonCreator
    public ApproximateHistogramFoldingAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="resolution") Integer resolution, @JsonProperty(value="numBuckets") Integer numBuckets, @JsonProperty(value="lowerLimit") Float lowerLimit, @JsonProperty(value="upperLimit") Float upperLimit) {
        super(name, fieldName, resolution, numBuckets, lowerLimit, upperLimit);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        Class cls;
        ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(this.fieldName);
        if (selector == null) {
            selector = new ObjectColumnSelector<ApproximateHistogram>(){

                public Class<ApproximateHistogram> classOfObject() {
                    return ApproximateHistogram.class;
                }

                public ApproximateHistogram get() {
                    return new ApproximateHistogram(0);
                }
            };
        }
        if ((cls = selector.classOfObject()).equals(Object.class) || ApproximateHistogram.class.isAssignableFrom(cls)) {
            return new ApproximateHistogramFoldingAggregator(this.name, (ObjectColumnSelector<ApproximateHistogram>)selector, this.resolution, this.lowerLimit, this.upperLimit);
        }
        throw new IAE("Incompatible type for metric[%s], expected a ApproximateHistogram, got a %s", new Object[]{this.fieldName, cls});
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        Class cls;
        ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(this.fieldName);
        if (selector == null) {
            selector = new ObjectColumnSelector<ApproximateHistogram>(){

                public Class<ApproximateHistogram> classOfObject() {
                    return ApproximateHistogram.class;
                }

                public ApproximateHistogram get() {
                    return new ApproximateHistogram(0);
                }
            };
        }
        if ((cls = selector.classOfObject()).equals(Object.class) || ApproximateHistogram.class.isAssignableFrom(cls)) {
            return new ApproximateHistogramFoldingBufferAggregator((ObjectColumnSelector<ApproximateHistogram>)selector, this.resolution, this.lowerLimit, this.upperLimit);
        }
        throw new IAE("Incompatible type for metric[%s], expected a ApproximateHistogram, got a %s", new Object[]{this.fieldName, cls});
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new ApproximateHistogramFoldingAggregatorFactory(this.name, this.name, this.resolution, this.numBuckets, Float.valueOf(this.lowerLimit), Float.valueOf(this.upperLimit));
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)this.fieldName);
        return ByteBuffer.allocate(1 + fieldNameBytes.length + 8 + 8).put((byte)13).put(fieldNameBytes).putInt(this.resolution).putInt(this.numBuckets).putFloat(this.lowerLimit).putFloat(this.upperLimit).array();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ApproximateHistogramAggregatorFactory that = (ApproximateHistogramAggregatorFactory)((Object)o);
        if (Float.compare(that.lowerLimit, this.lowerLimit) != 0) {
            return false;
        }
        if (this.numBuckets != that.numBuckets) {
            return false;
        }
        if (this.resolution != that.resolution) {
            return false;
        }
        if (Float.compare(that.upperLimit, this.upperLimit) != 0) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    @Override
    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        result = 31 * result + this.resolution;
        result = 31 * result + this.numBuckets;
        result = 31 * result + (this.lowerLimit != 0.0f ? Float.floatToIntBits(this.lowerLimit) : 0);
        result = 31 * result + (this.upperLimit != 0.0f ? Float.floatToIntBits(this.upperLimit) : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ApproximateHistogramFoldingAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", resolution=" + this.resolution + ", numBuckets=" + this.numBuckets + ", lowerLimit=" + this.lowerLimit + ", upperLimit=" + this.upperLimit + '}';
    }
}

