/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.httpclient5;

import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import io.dropwizard.metrics5.httpclient5.HttpClientMetricNameStrategy;
import java.io.IOException;
import java.util.Objects;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;

class InstrumentedAsyncExecChainHandler
implements AsyncExecChainHandler {
    private final MetricRegistry registry;
    private final HttpClientMetricNameStrategy metricNameStrategy;
    private final String name;

    public InstrumentedAsyncExecChainHandler(MetricRegistry registry, HttpClientMetricNameStrategy metricNameStrategy) {
        this(registry, metricNameStrategy, null);
    }

    public InstrumentedAsyncExecChainHandler(MetricRegistry registry, HttpClientMetricNameStrategy metricNameStrategy, String name) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.metricNameStrategy = Objects.requireNonNull(metricNameStrategy, "metricNameStrategy");
        this.name = name;
    }

    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        InstrumentedAsyncExecCallback instrumentedAsyncExecCallback = new InstrumentedAsyncExecCallback(this.registry, this.metricNameStrategy, this.name, asyncExecCallback, request);
        chain.proceed(request, entityProducer, scope, (AsyncExecCallback)instrumentedAsyncExecCallback);
    }

    static final class InstrumentedAsyncExecCallback
    implements AsyncExecCallback {
        private final MetricRegistry registry;
        private final HttpClientMetricNameStrategy metricNameStrategy;
        private final String name;
        private final AsyncExecCallback delegate;
        private final Timer.Context timerContext;

        public InstrumentedAsyncExecCallback(MetricRegistry registry, HttpClientMetricNameStrategy metricNameStrategy, String name, AsyncExecCallback delegate, HttpRequest request) {
            this.registry = registry;
            this.metricNameStrategy = metricNameStrategy;
            this.name = name;
            this.delegate = delegate;
            this.timerContext = this.timer(request).time();
        }

        public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
            return this.delegate.handleResponse(response, entityDetails);
        }

        public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
            this.delegate.handleInformationResponse(response);
        }

        public void completed() {
            this.delegate.completed();
            this.timerContext.stop();
        }

        public void failed(Exception cause) {
            this.delegate.failed(cause);
            this.meter(cause).mark();
            this.timerContext.stop();
        }

        private Timer timer(HttpRequest request) {
            return this.registry.timer(this.metricNameStrategy.getNameFor(this.name, request));
        }

        private Meter meter(Exception e) {
            return this.registry.meter(this.metricNameStrategy.getNameFor(this.name, e));
        }
    }
}

