/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.httpclient;

import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.httpclient.HttpClientMetricNameStrategies;
import io.dropwizard.metrics5.httpclient.HttpClientMetricNameStrategy;
import io.dropwizard.metrics5.httpclient.InstrumentedHttpClientConnectionManager;
import io.dropwizard.metrics5.httpclient.InstrumentedHttpRequestExecutor;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpRequestExecutor;

public class InstrumentedHttpClients {
    private InstrumentedHttpClients() {
    }

    public static CloseableHttpClient createDefault(MetricRegistry metricRegistry) {
        return InstrumentedHttpClients.createDefault(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY);
    }

    public static CloseableHttpClient createDefault(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy) {
        return InstrumentedHttpClients.custom(metricRegistry, metricNameStrategy).build();
    }

    public static HttpClientBuilder custom(MetricRegistry metricRegistry) {
        return InstrumentedHttpClients.custom(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY);
    }

    public static HttpClientBuilder custom(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy) {
        return HttpClientBuilder.create().setRequestExecutor((HttpRequestExecutor)new InstrumentedHttpRequestExecutor(metricRegistry, metricNameStrategy)).setConnectionManager((HttpClientConnectionManager)InstrumentedHttpClientConnectionManager.builder(metricRegistry).build());
    }
}

