/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.graphite;

import io.dropwizard.metrics5.Clock;
import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metered;
import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.ScheduledReporter;
import io.dropwizard.metrics5.Snapshot;
import io.dropwizard.metrics5.Timer;
import io.dropwizard.metrics5.graphite.Graphite;
import io.dropwizard.metrics5.graphite.GraphiteSender;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteReporter.class);
    private static final DoubleFunction<String> DEFAULT_FP_FORMATTER = fp -> String.format(Locale.US, "%2.2f", fp);
    private final GraphiteSender graphite;
    private final Clock clock;
    private final String prefix;
    private final boolean addMetricAttributesAsTags;
    private final DoubleFunction<String> floatingPointFormatter;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    protected GraphiteReporter(MetricRegistry registry, GraphiteSender graphite, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Set<MetricAttribute> disabledMetricAttributes) {
        this(registry, graphite, clock, prefix, rateUnit, durationUnit, filter, executor, shutdownExecutorOnStop, disabledMetricAttributes, false);
    }

    protected GraphiteReporter(MetricRegistry registry, GraphiteSender graphite, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Set<MetricAttribute> disabledMetricAttributes, boolean addMetricAttributesAsTags) {
        this(registry, graphite, clock, prefix, rateUnit, durationUnit, filter, executor, shutdownExecutorOnStop, disabledMetricAttributes, addMetricAttributesAsTags, DEFAULT_FP_FORMATTER);
    }

    protected GraphiteReporter(MetricRegistry registry, GraphiteSender graphite, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Set<MetricAttribute> disabledMetricAttributes, boolean addMetricAttributesAsTags, DoubleFunction<String> floatingPointFormatter) {
        super(registry, "graphite-reporter", filter, rateUnit, durationUnit, executor, shutdownExecutorOnStop, disabledMetricAttributes);
        this.graphite = graphite;
        this.clock = clock;
        this.prefix = prefix;
        this.addMetricAttributesAsTags = addMetricAttributesAsTags;
        this.floatingPointFormatter = floatingPointFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(SortedMap<MetricName, Gauge<?>> gauges, SortedMap<MetricName, Counter> counters, SortedMap<MetricName, Histogram> histograms, SortedMap<MetricName, Meter> meters, SortedMap<MetricName, Timer> timers) {
        long timestamp = this.clock.getTime() / 1000L;
        try {
            this.graphite.connect();
            for (Map.Entry<MetricName, Gauge<?>> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), timestamp);
            }
            for (Map.Entry<MetricName, Gauge<?>> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue(), timestamp);
            }
            for (Map.Entry<MetricName, Gauge<?>> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), timestamp);
            }
            for (Map.Entry<MetricName, Gauge<?>> entry : meters.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue(), timestamp, false);
            }
            for (Map.Entry<MetricName, Gauge<?>> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue(), timestamp);
            }
            this.graphite.flush();
        }
        catch (IOException e) {
            LOGGER.warn("Unable to report to Graphite", (Object)this.graphite, (Object)e);
        }
        finally {
            try {
                this.graphite.close();
            }
            catch (IOException e1) {
                LOGGER.warn("Error closing Graphite", (Object)this.graphite, (Object)e1);
            }
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.graphite.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error disconnecting from Graphite", (Object)this.graphite, (Object)e);
            }
        }
    }

    private void reportTimer(MetricName name, Timer timer, long timestamp) throws IOException {
        Snapshot snapshot = timer.getSnapshot();
        this.sendIfEnabled(MetricAttribute.MAX, name, this.convertDuration(snapshot.getMax()), timestamp);
        this.sendIfEnabled(MetricAttribute.MEAN, name, this.convertDuration(snapshot.getMean()), timestamp);
        this.sendIfEnabled(MetricAttribute.MIN, name, this.convertDuration(snapshot.getMin()), timestamp);
        this.sendIfEnabled(MetricAttribute.STDDEV, name, this.convertDuration(snapshot.getStdDev()), timestamp);
        this.sendIfEnabled(MetricAttribute.P50, name, this.convertDuration(snapshot.getMedian()), timestamp);
        this.sendIfEnabled(MetricAttribute.P75, name, this.convertDuration(snapshot.get75thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P95, name, this.convertDuration(snapshot.get95thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P98, name, this.convertDuration(snapshot.get98thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P99, name, this.convertDuration(snapshot.get99thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P999, name, this.convertDuration(snapshot.get999thPercentile()), timestamp);
        this.reportMetered(name, (Metered)timer, timestamp, true);
    }

    private void reportMetered(MetricName name, Metered meter, long timestamp, boolean sumIsDuration) throws IOException {
        this.sendIfEnabled(MetricAttribute.COUNT, name, meter.getCount(), timestamp);
        this.sendIfEnabled(MetricAttribute.SUM, name, sumIsDuration ? this.convertDuration(meter.getSum()) : (double)meter.getSum(), timestamp);
        this.sendIfEnabled(MetricAttribute.M1_RATE, name, this.convertRate(meter.getOneMinuteRate()), timestamp);
        this.sendIfEnabled(MetricAttribute.M5_RATE, name, this.convertRate(meter.getFiveMinuteRate()), timestamp);
        this.sendIfEnabled(MetricAttribute.M15_RATE, name, this.convertRate(meter.getFifteenMinuteRate()), timestamp);
        this.sendIfEnabled(MetricAttribute.MEAN_RATE, name, this.convertRate(meter.getMeanRate()), timestamp);
    }

    private void reportHistogram(MetricName name, Histogram histogram, long timestamp) throws IOException {
        Snapshot snapshot = histogram.getSnapshot();
        this.sendIfEnabled(MetricAttribute.COUNT, name, histogram.getCount(), timestamp);
        this.sendIfEnabled(MetricAttribute.SUM, name, histogram.getSum(), timestamp);
        this.sendIfEnabled(MetricAttribute.MAX, name, snapshot.getMax(), timestamp);
        this.sendIfEnabled(MetricAttribute.MEAN, name, snapshot.getMean(), timestamp);
        this.sendIfEnabled(MetricAttribute.MIN, name, snapshot.getMin(), timestamp);
        this.sendIfEnabled(MetricAttribute.STDDEV, name, snapshot.getStdDev(), timestamp);
        this.sendIfEnabled(MetricAttribute.P50, name, snapshot.getMedian(), timestamp);
        this.sendIfEnabled(MetricAttribute.P75, name, snapshot.get75thPercentile(), timestamp);
        this.sendIfEnabled(MetricAttribute.P95, name, snapshot.get95thPercentile(), timestamp);
        this.sendIfEnabled(MetricAttribute.P98, name, snapshot.get98thPercentile(), timestamp);
        this.sendIfEnabled(MetricAttribute.P99, name, snapshot.get99thPercentile(), timestamp);
        this.sendIfEnabled(MetricAttribute.P999, name, snapshot.get999thPercentile(), timestamp);
    }

    private void sendIfEnabled(MetricAttribute type, MetricName name, double value, long timestamp) throws IOException {
        if (this.getDisabledMetricAttributes().contains(type)) {
            return;
        }
        this.graphite.send(this.prefix(this.appendMetricAttribute(name, type.getCode())), this.format(value), timestamp);
    }

    private void sendIfEnabled(MetricAttribute type, MetricName name, long value, long timestamp) throws IOException {
        if (this.getDisabledMetricAttributes().contains(type)) {
            return;
        }
        this.graphite.send(this.prefix(this.appendMetricAttribute(name, type.getCode())), this.format(value), timestamp);
    }

    private void reportCounter(MetricName name, Counter counter, long timestamp) throws IOException {
        this.graphite.send(this.prefix(this.appendMetricAttribute(name, MetricAttribute.COUNT.getCode())), this.format(counter.getCount()), timestamp);
    }

    private void reportGauge(MetricName name, Gauge<?> gauge, long timestamp) throws IOException {
        String value = this.format(gauge.getValue());
        if (value != null) {
            this.graphite.send(this.prefix(name.getKey()), value, timestamp);
        }
    }

    private String format(Object o) {
        if (o instanceof Float) {
            return this.format(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.format((Double)o);
        }
        if (o instanceof Byte) {
            return this.format(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.format(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.format(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.format((Long)o);
        }
        if (o instanceof Number) {
            return this.format(((Number)o).doubleValue());
        }
        if (o instanceof Boolean) {
            return this.format((Boolean)o != false ? 1L : 0L);
        }
        return null;
    }

    private String prefix(String name) {
        return this.prefix + "." + name;
    }

    private String appendMetricAttribute(MetricName name, String metricAttribute) {
        if (this.addMetricAttributesAsTags) {
            return name.getKey() + ";metricattribute=" + metricAttribute;
        }
        return name.getKey() + "." + metricAttribute;
    }

    private String format(long n) {
        return Long.toString(n);
    }

    protected String format(double v) {
        return this.floatingPointFormatter.apply(v);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private ScheduledExecutorService executor;
        private boolean shutdownExecutorOnStop;
        private Set<MetricAttribute> disabledMetricAttributes;
        private boolean addMetricAttributesAsTags;
        private DoubleFunction<String> floatingPointFormatter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.executor = null;
            this.shutdownExecutorOnStop = true;
            this.disabledMetricAttributes = Collections.emptySet();
            this.addMetricAttributesAsTags = false;
            this.floatingPointFormatter = DEFAULT_FP_FORMATTER;
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder disabledMetricAttributes(Set<MetricAttribute> disabledMetricAttributes) {
            this.disabledMetricAttributes = disabledMetricAttributes;
            return this;
        }

        public Builder addMetricAttributesAsTags(boolean addMetricAttributesAsTags) {
            this.addMetricAttributesAsTags = addMetricAttributesAsTags;
            return this;
        }

        public Builder withFloatingPointFormatter(DoubleFunction<String> floatingPointFormatter) {
            this.floatingPointFormatter = floatingPointFormatter;
            return this;
        }

        public GraphiteReporter build(Graphite graphite) {
            return this.build((GraphiteSender)graphite);
        }

        public GraphiteReporter build(GraphiteSender graphite) {
            return new GraphiteReporter(this.registry, graphite, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter, this.executor, this.shutdownExecutorOnStop, this.disabledMetricAttributes, this.addMetricAttributesAsTags, this.floatingPointFormatter);
        }
    }
}

