/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MetricName
implements Comparable<MetricName> {
    private static final String SEPARATOR = ".";
    private static final SortedMap<String, String> EMPTY_TAGS = Collections.emptySortedMap();
    static final MetricName EMPTY = new MetricName("", EMPTY_TAGS);
    private final String key;
    private final SortedMap<String, String> tags;

    public static MetricName empty() {
        return EMPTY;
    }

    public MetricName(String key, Map<String, String> tags) {
        this.key = Objects.requireNonNull(key, "Metric key must not be null");
        this.tags = tags == null || tags.isEmpty() ? EMPTY_TAGS : (tags instanceof SortedMap ? Collections.unmodifiableSortedMap((SortedMap)tags) : Collections.unmodifiableSortedMap(new TreeMap<String, String>(tags)));
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public MetricName resolve(String ... parts) {
        if (parts == null || parts.length == 0) {
            return this;
        }
        String newKey = Stream.concat(Stream.of(this.key), Stream.of(parts)).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining(SEPARATOR));
        return new MetricName(newKey, this.tags);
    }

    public MetricName tagged(Map<String, String> add) {
        if (add == null) {
            return this;
        }
        TreeMap<String, String> newTags = new TreeMap<String, String>(this.tags);
        newTags.putAll(add);
        return new MetricName(this.key, newTags);
    }

    public MetricName tagged(String ... pairs) {
        if (pairs == null || pairs.length == 0) {
            return this;
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Argument count must be even");
        }
        TreeMap<String, String> newTags = new TreeMap<String, String>(this.tags);
        for (int i = 0; i < pairs.length; i += 2) {
            newTags.put(pairs[i], pairs[i + 1]);
        }
        return new MetricName(this.key, newTags);
    }

    public MetricName append(MetricName append) {
        return this.resolve(append.key).tagged(append.tags);
    }

    public static MetricName build(String ... parts) {
        return EMPTY.resolve(parts);
    }

    public String toString() {
        if (this.tags.isEmpty()) {
            return MetricName.escapeKey(this.key);
        }
        StringBuilder builder = new StringBuilder();
        if (!this.key.isEmpty()) {
            builder.append(MetricName.escapeKey(this.key));
        }
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            builder.append(',');
            builder.append(MetricName.escapeTag(entry.getKey()));
            builder.append('=');
            builder.append(MetricName.escapeTag(entry.getValue()));
        }
        return builder.toString();
    }

    public static MetricName parse(String metricNameString) {
        if (metricNameString == null || metricNameString.isEmpty()) {
            return EMPTY;
        }
        int firstCommaIndex = MetricName.findFirstUnescapedComma(metricNameString);
        if (firstCommaIndex == -1) {
            return new MetricName(MetricName.unescapeKey(metricNameString), EMPTY_TAGS);
        }
        String keyPart = metricNameString.substring(0, firstCommaIndex);
        String tagsPart = metricNameString.substring(firstCommaIndex + 1);
        String key = MetricName.unescapeKey(keyPart);
        SortedMap<String, String> tags = MetricName.parseTags(tagsPart);
        return new MetricName(key, tags);
    }

    private static int findFirstUnescapedComma(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ',' || MetricName.isEscaped(str, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isEscaped(String str, int index) {
        if (index == 0) {
            return false;
        }
        int backslashCount = 0;
        for (int i = index - 1; i >= 0 && str.charAt(i) == '\\'; --i) {
            ++backslashCount;
        }
        return backslashCount % 2 == 1;
    }

    private static SortedMap<String, String> parseTags(String tagsPart) {
        TreeMap<String, String> tags = new TreeMap<String, String>();
        if (tagsPart.isEmpty()) {
            return tags;
        }
        if (tagsPart.endsWith(",")) {
            throw new IllegalArgumentException("Trailing comma in tags");
        }
        if (tagsPart.contains(",,")) {
            throw new IllegalArgumentException("Consecutive commas in tags");
        }
        int start = 0;
        while (start < tagsPart.length()) {
            int commaIndex = MetricName.findNextUnescapedComma(tagsPart, start);
            int endIndex = commaIndex == -1 ? tagsPart.length() : commaIndex;
            String tagPair = tagsPart.substring(start, endIndex);
            MetricName.parseTagPair(tagPair, tags);
            start = endIndex + 1;
        }
        return tags;
    }

    private static int findNextUnescapedComma(String str, int startFrom) {
        for (int i = startFrom; i < str.length(); ++i) {
            if (str.charAt(i) != ',' || MetricName.isEscaped(str, i)) continue;
            return i;
        }
        return -1;
    }

    private static void parseTagPair(String tagPair, Map<String, String> tags) {
        if (tagPair.trim().isEmpty()) {
            throw new IllegalArgumentException("Empty tag pair");
        }
        int equalIndex = MetricName.findFirstUnescapedEquals(tagPair);
        if (equalIndex == -1) {
            throw new IllegalArgumentException("Invalid tag format: " + tagPair);
        }
        if (equalIndex == 0) {
            throw new IllegalArgumentException("Empty tag key in: " + tagPair);
        }
        String key = MetricName.unescapeTag(tagPair.substring(0, equalIndex));
        String value = MetricName.unescapeTag(tagPair.substring(equalIndex + 1));
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Empty tag key after unescaping in: " + tagPair);
        }
        tags.put(key, value);
    }

    private static int findFirstUnescapedEquals(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '=' || MetricName.isEscaped(str, i)) continue;
            return i;
        }
        return -1;
    }

    private static String escapeKey(String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        StringBuilder escaped = new StringBuilder(key.length());
        block9: for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            switch (c) {
                case '\\': {
                    escaped.append("\\\\");
                    continue block9;
                }
                case ',': {
                    escaped.append("\\,");
                    continue block9;
                }
                case '=': {
                    escaped.append("\\=");
                    continue block9;
                }
                case ' ': {
                    escaped.append("\\ ");
                    continue block9;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block9;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block9;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c == '\u007f') {
                        escaped.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }

    private static String escapeTag(String tag) {
        if (tag == null || tag.isEmpty()) {
            return tag;
        }
        StringBuilder escaped = new StringBuilder(tag.length());
        block9: for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            switch (c) {
                case '\\': {
                    escaped.append("\\\\");
                    continue block9;
                }
                case ',': {
                    escaped.append("\\,");
                    continue block9;
                }
                case '=': {
                    escaped.append("\\=");
                    continue block9;
                }
                case ' ': {
                    escaped.append("\\ ");
                    continue block9;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block9;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block9;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c == '\u007f') {
                        escaped.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }

    private static String unescapeKey(String escapedKey) {
        if (escapedKey == null || escapedKey.trim().isEmpty()) {
            return escapedKey;
        }
        StringBuilder unescaped = new StringBuilder(escapedKey.length());
        for (int i = 0; i < escapedKey.length(); ++i) {
            char c = escapedKey.charAt(i);
            if (c == '\\' && i + 1 < escapedKey.length()) {
                char next = escapedKey.charAt(i + 1);
                switch (next) {
                    case '\\': {
                        unescaped.append('\\');
                        ++i;
                        break;
                    }
                    case ',': {
                        unescaped.append(',');
                        ++i;
                        break;
                    }
                    case '=': {
                        unescaped.append('=');
                        ++i;
                        break;
                    }
                    case ' ': {
                        unescaped.append(' ');
                        ++i;
                        break;
                    }
                    case 'n': {
                        unescaped.append('\n');
                        ++i;
                        break;
                    }
                    case 't': {
                        unescaped.append('\t');
                        ++i;
                        break;
                    }
                    case 'r': {
                        unescaped.append('\r');
                        ++i;
                        break;
                    }
                    case 'u': {
                        if (i + 6 <= escapedKey.length()) {
                            String hex = escapedKey.substring(i + 2, i + 6);
                            try {
                                int codePoint = Integer.parseInt(hex, 16);
                                unescaped.append((char)codePoint);
                                i += 5;
                                break;
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Invalid unicode escape sequence: \\u" + hex);
                            }
                        }
                        throw new IllegalArgumentException("Incomplete unicode escape sequence at end of string");
                    }
                    default: {
                        unescaped.append(c);
                    }
                }
                continue;
            }
            if (c == '\\') {
                throw new IllegalArgumentException("Incomplete escape sequence at end of string");
            }
            unescaped.append(c);
        }
        return unescaped.toString();
    }

    private static String unescapeTag(String escapedTag) {
        if (escapedTag == null || escapedTag.trim().isEmpty()) {
            return escapedTag;
        }
        StringBuilder unescaped = new StringBuilder(escapedTag.length());
        for (int i = 0; i < escapedTag.length(); ++i) {
            char c = escapedTag.charAt(i);
            if (c == '\\' && i + 1 < escapedTag.length()) {
                char next = escapedTag.charAt(i + 1);
                switch (next) {
                    case '\\': {
                        unescaped.append('\\');
                        ++i;
                        break;
                    }
                    case ',': {
                        unescaped.append(',');
                        ++i;
                        break;
                    }
                    case '=': {
                        unescaped.append('=');
                        ++i;
                        break;
                    }
                    case ' ': {
                        unescaped.append(' ');
                        ++i;
                        break;
                    }
                    case 'n': {
                        unescaped.append('\n');
                        ++i;
                        break;
                    }
                    case 't': {
                        unescaped.append('\t');
                        ++i;
                        break;
                    }
                    case 'r': {
                        unescaped.append('\r');
                        ++i;
                        break;
                    }
                    case 'u': {
                        if (i + 6 <= escapedTag.length()) {
                            String hex = escapedTag.substring(i + 2, i + 6);
                            try {
                                int codePoint = Integer.parseInt(hex, 16);
                                unescaped.append((char)codePoint);
                                i += 5;
                                break;
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Invalid unicode escape sequence: \\u" + hex);
                            }
                        }
                        throw new IllegalArgumentException("Incomplete unicode escape sequence at end of string");
                    }
                    default: {
                        unescaped.append(c);
                    }
                }
                continue;
            }
            if (c == '\\') {
                throw new IllegalArgumentException("Incomplete escape sequence at end of string");
            }
            unescaped.append(c);
        }
        return unescaped.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricName)) {
            return false;
        }
        MetricName that = (MetricName)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.tags);
    }

    @Override
    public int compareTo(MetricName o) {
        int c = this.key.compareTo(o.getKey());
        if (c != 0) {
            return c;
        }
        return this.compareTags(this.tags, o.getTags());
    }

    private int compareTags(Map<String, String> left, Map<String, String> right) {
        Iterator<Map.Entry<String, String>> lit = left.entrySet().iterator();
        Iterator<Map.Entry<String, String>> rit = right.entrySet().iterator();
        while (lit.hasNext() && rit.hasNext()) {
            Map.Entry<String, String> l = lit.next();
            Map.Entry<String, String> r = rit.next();
            int c = l.getKey().compareTo(r.getKey());
            if (c != 0) {
                return c;
            }
            if (l.getValue() == null && r.getValue() == null) {
                return 0;
            }
            if (l.getValue() == null) {
                return -1;
            }
            if (r.getValue() == null) {
                return 1;
            }
            c = l.getValue().compareTo(r.getValue());
            if (c == 0) continue;
            return c;
        }
        if (lit.hasNext()) {
            return 1;
        }
        if (rit.hasNext()) {
            return -1;
        }
        return 0;
    }
}

