/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.httpclient;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategies;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategy;
import com.codahale.metrics.httpclient.InstrumentedHttpClientConnectionManager;
import com.codahale.metrics.httpclient.InstrumentedHttpRequestExecutor;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpRequestExecutor;

public class InstrumentedHttpClients {
    private InstrumentedHttpClients() {
    }

    public static CloseableHttpClient createDefault(MetricRegistry metricRegistry) {
        return InstrumentedHttpClients.createDefault(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY);
    }

    public static CloseableHttpClient createDefault(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy) {
        return InstrumentedHttpClients.custom(metricRegistry, metricNameStrategy).build();
    }

    public static HttpClientBuilder custom(MetricRegistry metricRegistry) {
        return InstrumentedHttpClients.custom(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY);
    }

    public static HttpClientBuilder custom(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy) {
        return HttpClientBuilder.create().setRequestExecutor((HttpRequestExecutor)new InstrumentedHttpRequestExecutor(metricRegistry, metricNameStrategy)).setConnectionManager((HttpClientConnectionManager)new InstrumentedHttpClientConnectionManager(metricRegistry));
    }
}

