/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.benchmarks;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.codahale.metrics.SlidingTimeWindowReservoir;
import com.codahale.metrics.SlidingWindowReservoir;
import com.codahale.metrics.UniformReservoir;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

@State(value=Scope.Benchmark)
public class ReservoirBenchmark {
    private final UniformReservoir uniform = new UniformReservoir();
    private final ExponentiallyDecayingReservoir exponential = new ExponentiallyDecayingReservoir();
    private final SlidingWindowReservoir sliding = new SlidingWindowReservoir(1000);
    private final SlidingTimeWindowReservoir slidingTime = new SlidingTimeWindowReservoir(200L, TimeUnit.MILLISECONDS);
    private final SlidingTimeWindowArrayReservoir arrTime = new SlidingTimeWindowArrayReservoir(200L, TimeUnit.MILLISECONDS);
    private long nextValue = -67392582L;

    @Benchmark
    public Object perfUniformReservoir() {
        this.uniform.update(this.nextValue);
        return this.uniform;
    }

    @Benchmark
    public Object perfSlidingTimeWindowArrayReservoir() {
        this.arrTime.update(this.nextValue);
        return this.arrTime;
    }

    @Benchmark
    public Object perfExponentiallyDecayingReservoir() {
        this.exponential.update(this.nextValue);
        return this.exponential;
    }

    @Benchmark
    public Object perfSlidingWindowReservoir() {
        this.sliding.update(this.nextValue);
        return this.sliding;
    }

    @Benchmark
    public Object perfSlidingTimeWindowReservoir() {
        this.slidingTime.update(this.nextValue);
        return this.slidingTime;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + ReservoirBenchmark.class.getSimpleName() + ".*").warmupIterations(10).measurementIterations(10).addProfiler(GCProfiler.class).measurementTime(TimeValue.seconds((long)3L)).timeUnit(TimeUnit.MICROSECONDS).mode(Mode.AverageTime).threads(4).forks(1).build();
        new Runner(opt).run();
    }
}

