/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets.assets;

import com.google.common.base.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ByteRange {
    private final int start;
    private final int end;

    public ByteRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public static ByteRange parse(String byteRange, int resourceLength) throws NumberFormatException {
        if (byteRange.indexOf("-") == -1) {
            int start = Integer.parseInt(byteRange);
            return new ByteRange(start, resourceLength - 1);
        }
        if (byteRange.indexOf("-") == 0) {
            int start = Integer.parseInt(byteRange);
            return new ByteRange(resourceLength + start, resourceLength - 1);
        }
        String[] parts = byteRange.split("-");
        if (parts.length == 2) {
            int start = Integer.parseInt(parts[0]);
            int end = Integer.parseInt(parts[1]);
            if (end > resourceLength) {
                end = resourceLength - 1;
            }
            return new ByteRange(start, end);
        }
        int start = Integer.parseInt(parts[0]);
        return new ByteRange(start, resourceLength - 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ByteRange other = (ByteRange)obj;
        return Objects.equal((Object)this.start, (Object)other.start) && Objects.equal((Object)this.end, (Object)other.end);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.end});
    }

    public String toString() {
        return String.format("%d-%d", this.start, this.end);
    }
}

