/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterAttachable;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.dropwizard.logging.AppenderFactory;
import io.dropwizard.logging.DropwizardLayout;
import java.util.TimeZone;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public abstract class AbstractAppenderFactory
implements AppenderFactory {
    @NotNull
    protected Level threshold = Level.ALL;
    protected String logFormat;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private int queueSize = 256;
    private int discardingThreshold = -1;
    private boolean includeCallerData = false;

    @JsonProperty
    public int getQueueSize() {
        return this.queueSize;
    }

    @JsonProperty
    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    @JsonProperty
    public int getDiscardingThreshold() {
        return this.discardingThreshold;
    }

    @JsonProperty
    public void setDiscardingThreshold(int discardingThreshold) {
        this.discardingThreshold = discardingThreshold;
    }

    @JsonProperty
    public Level getThreshold() {
        return this.threshold;
    }

    @JsonProperty
    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }

    @JsonProperty
    public String getLogFormat() {
        return this.logFormat;
    }

    @JsonProperty
    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    @JsonProperty
    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    @JsonProperty
    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    protected Appender<ILoggingEvent> wrapAsync(Appender<ILoggingEvent> appender) {
        return this.wrapAsync(appender, appender.getContext());
    }

    protected Appender<ILoggingEvent> wrapAsync(Appender<ILoggingEvent> appender, Context context) {
        AsyncAppender asyncAppender = new AsyncAppender();
        asyncAppender.setIncludeCallerData(this.includeCallerData);
        asyncAppender.setQueueSize(this.queueSize);
        asyncAppender.setDiscardingThreshold(this.discardingThreshold);
        asyncAppender.setContext(context);
        asyncAppender.setName("async-" + appender.getName());
        asyncAppender.addAppender(appender);
        asyncAppender.start();
        return asyncAppender;
    }

    protected void addThresholdFilter(FilterAttachable<ILoggingEvent> appender, Level threshold) {
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(threshold.toString());
        filter.start();
        appender.addFilter((Filter)filter);
    }

    protected DropwizardLayout buildLayout(LoggerContext context, TimeZone timeZone) {
        DropwizardLayout formatter = new DropwizardLayout(context, timeZone);
        if (!Strings.isNullOrEmpty((String)this.logFormat)) {
            formatter.setPattern(this.logFormat);
        }
        formatter.start();
        return formatter;
    }
}

