/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jmx.JMXConfigurator;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.logback.InstrumentedAppender;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.logging.AppenderFactory;
import io.dropwizard.logging.ConsoleAppenderFactory;
import io.dropwizard.logging.LoggerConfiguration;
import io.dropwizard.logging.LoggingFactory;
import io.dropwizard.logging.LoggingUtil;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="default")
public class DefaultLoggingFactory
implements LoggingFactory {
    private static final ReentrantLock MBEAN_REGISTRATION_LOCK = new ReentrantLock();
    private static final ReentrantLock CHANGE_LOGGER_CONTEXT_LOCK = new ReentrantLock();
    @NotNull
    private Level level = Level.INFO;
    @NotNull
    private ImmutableMap<String, JsonNode> loggers = ImmutableMap.of();
    @Valid
    @NotNull
    private ImmutableList<AppenderFactory> appenders = ImmutableList.of((Object)new ConsoleAppenderFactory());
    @JsonIgnore
    private final LoggerContext loggerContext;
    @JsonIgnore
    private final PrintStream configurationErrorsStream;

    public DefaultLoggingFactory() {
        this(LoggingUtil.getLoggerContext(), System.err);
    }

    @VisibleForTesting
    DefaultLoggingFactory(LoggerContext loggerContext, PrintStream configurationErrorsStream) {
        this.loggerContext = (LoggerContext)Preconditions.checkNotNull((Object)loggerContext);
        this.configurationErrorsStream = (PrintStream)Preconditions.checkNotNull((Object)configurationErrorsStream);
    }

    @VisibleForTesting
    LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    @VisibleForTesting
    PrintStream getConfigurationErrorsStream() {
        return this.configurationErrorsStream;
    }

    @JsonProperty
    public Level getLevel() {
        return this.level;
    }

    @JsonProperty
    public void setLevel(Level level) {
        this.level = level;
    }

    @JsonProperty
    public ImmutableMap<String, JsonNode> getLoggers() {
        return this.loggers;
    }

    @JsonProperty
    public void setLoggers(Map<String, JsonNode> loggers) {
        this.loggers = ImmutableMap.copyOf(loggers);
    }

    @JsonProperty
    public ImmutableList<AppenderFactory> getAppenders() {
        return this.appenders;
    }

    @JsonProperty
    public void setAppenders(List<AppenderFactory> appenders) {
        this.appenders = ImmutableList.copyOf(appenders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(MetricRegistry metricRegistry, String name) {
        Logger root;
        LoggingUtil.hijackJDKLogging();
        CHANGE_LOGGER_CONTEXT_LOCK.lock();
        try {
            root = this.configureLoggers(name);
        }
        finally {
            CHANGE_LOGGER_CONTEXT_LOCK.unlock();
        }
        for (AppenderFactory output : this.appenders) {
            root.addAppender(output.build(this.loggerContext, name, null));
        }
        StatusPrinter.setPrintStream((PrintStream)this.configurationErrorsStream);
        try {
            StatusPrinter.printIfErrorsOccured((Context)this.loggerContext);
        }
        finally {
            StatusPrinter.setPrintStream((PrintStream)System.out);
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        MBEAN_REGISTRATION_LOCK.lock();
        try {
            ObjectName objectName = new ObjectName("io.dropwizard:type=Logging");
            if (!server.isRegistered(objectName)) {
                server.registerMBean(new JMXConfigurator(this.loggerContext, server, objectName), objectName);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
        finally {
            MBEAN_REGISTRATION_LOCK.unlock();
        }
        this.configureInstrumentation(root, metricRegistry);
    }

    @Override
    public void stop() {
        CHANGE_LOGGER_CONTEXT_LOCK.lock();
        try {
            this.loggerContext.stop();
        }
        finally {
            CHANGE_LOGGER_CONTEXT_LOCK.unlock();
        }
    }

    private void configureInstrumentation(Logger root, MetricRegistry metricRegistry) {
        InstrumentedAppender appender = new InstrumentedAppender(metricRegistry);
        appender.setContext((Context)this.loggerContext);
        appender.start();
        root.addAppender((Appender)appender);
    }

    private Logger configureLoggers(String name) {
        Logger root = this.loggerContext.getLogger("ROOT");
        this.loggerContext.reset();
        LevelChangePropagator propagator = new LevelChangePropagator();
        propagator.setContext((Context)this.loggerContext);
        propagator.setResetJUL(true);
        this.loggerContext.addListener((LoggerContextListener)propagator);
        root.setLevel(this.level);
        for (Map.Entry entry : this.loggers.entrySet()) {
            Logger logger = this.loggerContext.getLogger((String)entry.getKey());
            JsonNode jsonNode = (JsonNode)entry.getValue();
            if (jsonNode.isTextual()) {
                logger.setLevel(Level.valueOf((String)jsonNode.asText()));
                continue;
            }
            if (jsonNode.isObject()) {
                LoggerConfiguration configuration;
                try {
                    configuration = (LoggerConfiguration)Jackson.newObjectMapper().treeToValue((TreeNode)jsonNode, LoggerConfiguration.class);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("Wrong format of logger '" + (String)entry.getKey() + "'", e);
                }
                logger.setLevel(configuration.getLevel());
                logger.setAdditive(configuration.isAdditive());
                for (AppenderFactory appender : configuration.getAppenders()) {
                    logger.addAppender(appender.build(this.loggerContext, name, null));
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported format of logger '" + (String)entry.getKey() + "'");
        }
        return root;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("level", (Object)this.level).add("loggers", this.loggers).add("appenders", this.appenders).toString();
    }
}

