/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

@Singleton
public class OptionalLongParamConverterProvider
implements ParamConverterProvider {
    private OptionalLongParamConverter paramConverter = new OptionalLongParamConverter();

    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        return OptionalLong.class.equals(rawType) ? this.paramConverter : null;
    }

    public static class OptionalLongParamConverter
    implements ParamConverter<OptionalLong> {
        public OptionalLong fromString(String value) {
            if (value == null) {
                return OptionalLong.empty();
            }
            try {
                return OptionalLong.of(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public String toString(OptionalLong value) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            return value.isPresent() ? Long.toString(value.getAsLong()) : "";
        }
    }
}

