/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.filter;

import com.google.common.annotations.VisibleForTesting;
import io.dropwizard.util.Duration;
import java.io.IOException;
import java.util.function.Supplier;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
public class RuntimeFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final float NANOS_IN_SECOND = Duration.seconds((long)1L).toNanoseconds();
    private static final String RUNTIME_HEADER = "X-Runtime";
    private static final String RUNTIME_PROPERTY = "io.dropwizard.jersey.filter.runtime";
    private Supplier<Long> currentTimeProvider = System::nanoTime;

    @VisibleForTesting
    void setCurrentTimeProvider(Supplier<Long> currentTimeProvider) {
        this.currentTimeProvider = currentTimeProvider;
    }

    public void filter(ContainerRequestContext request) throws IOException {
        request.setProperty(RUNTIME_PROPERTY, (Object)this.currentTimeProvider.get());
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        Long startTime = (Long)request.getProperty(RUNTIME_PROPERTY);
        if (startTime != null) {
            float seconds = (float)(this.currentTimeProvider.get() - startTime) / NANOS_IN_SECOND;
            response.getHeaders().putSingle((Object)RUNTIME_HEADER, (Object)String.format("%.6f", Float.valueOf(seconds)));
        }
    }
}

