/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.common.collect.ImmutableSet;
import io.dropwizard.validation.ConstraintViolations;
import io.dropwizard.validation.Validated;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonMessageBodyProvider
extends JacksonJaxbJsonProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonMessageBodyProvider.class);
    private static final Class<?>[] DEFAULT_GROUP_ARRAY = new Class[]{Default.class};
    private final ObjectMapper mapper;
    private final Validator validator;

    public JacksonMessageBodyProvider(ObjectMapper mapper, Validator validator) {
        this.validator = validator;
        this.mapper = mapper;
        this.setMapper(mapper);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isProvidable(type) && super.isReadable(type, genericType, annotations, mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return this.validate(annotations, super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream));
    }

    private Object validate(Annotation[] annotations, Object value) {
        if (null == value) {
            throw new ConstraintViolationException("The request entity was empty", Collections.emptySet());
        }
        Class[] classes = this.findValidationGroups(annotations);
        if (classes != null) {
            Set violations = null;
            if (value instanceof Map) {
                violations = this.validate(((Map)value).values(), classes);
            } else if (value instanceof Iterable) {
                violations = this.validate((Iterable)value, classes);
            } else if (value.getClass().isArray()) {
                Object[] values;
                violations = new HashSet<ConstraintViolation<Object>>();
                for (Object item : values = (Object[])value) {
                    violations.addAll(this.validator.validate(item, classes));
                }
            } else {
                violations = this.validator.validate(value, classes);
            }
            if (violations != null && !violations.isEmpty()) {
                ImmutableSet constraintViolations = ConstraintViolations.copyOf((Set)violations);
                LOGGER.trace("Validation failed: {}; original data was {}", (Object)ConstraintViolations.formatUntyped((Set)constraintViolations), value);
                throw new ConstraintViolationException("The request entity had the following errors:", (Set)constraintViolations);
            }
        }
        return value;
    }

    private Set<ConstraintViolation<Object>> validate(Iterable values, Class<?>[] classes) {
        HashSet<ConstraintViolation<Object>> violations = new HashSet<ConstraintViolation<Object>>();
        for (Object value : values) {
            violations.addAll(this.validator.validate(value, (Class[])classes));
        }
        return violations;
    }

    private Class<?>[] findValidationGroups(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() == Valid.class) {
                return DEFAULT_GROUP_ARRAY;
            }
            if (annotation.annotationType() != Validated.class) continue;
            return ((Validated)annotation).value();
        }
        return null;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isProvidable(type) && super.isWriteable(type, genericType, annotations, mediaType);
    }

    private boolean isProvidable(Class<?> type) {
        JsonIgnoreType ignore = type.getAnnotation(JsonIgnoreType.class);
        return ignore == null || !ignore.value();
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }
}

