/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.core.cli;

import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.ConfiguredCommand;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import net.sourceforge.argparse4j.inf.Namespace;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class EnvironmentCommand<T extends Configuration>
extends ConfiguredCommand<T> {
    private final Application<T> application;
    private @Nullable Environment environment;

    protected EnvironmentCommand(Application<T> application, String name, String description) {
        super(name, description);
        this.application = application;
    }

    public @Nullable Environment getEnvironment() {
        return this.environment;
    }

    @Override
    protected void run(Bootstrap<T> bootstrap, Namespace namespace, T configuration) throws Exception {
        this.environment = new Environment(bootstrap.getApplication().getName(), bootstrap.getObjectMapper(), bootstrap.getValidatorFactory(), bootstrap.getMetricRegistry(), bootstrap.getClassLoader(), bootstrap.getHealthCheckRegistry(), (Configuration)configuration);
        ((Configuration)configuration).getMetricsFactory().configure(this.environment.lifecycle(), bootstrap.getMetricRegistry());
        ((Configuration)configuration).getServerFactory().configure(this.environment);
        ((Configuration)configuration).getHealthFactory().ifPresent(health -> health.configure(this.environment.lifecycle(), this.environment.servlets(), this.environment.jersey(), this.environment.health(), this.environment.getObjectMapper(), this.application.getName()));
        bootstrap.run(configuration, this.environment);
        this.application.run(configuration, this.environment);
        this.run(this.environment, namespace, configuration);
    }

    protected abstract void run(Environment var1, Namespace var2, T var3) throws Exception;
}

