/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient5.HttpClientMetricNameStrategy;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.client.ConfiguredCloseableHttpClient;
import io.dropwizard.client.DropwizardApacheConnector;
import io.dropwizard.client.DropwizardExecutorProvider;
import io.dropwizard.client.HttpClientBuilder;
import io.dropwizard.client.JerseyClientConfiguration;
import io.dropwizard.client.JerseyIgnoreRequestUserAgentHeaderFilter;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jersey.gzip.ConfiguredGZipEncoder;
import io.dropwizard.jersey.gzip.GZipDecoder;
import io.dropwizard.jersey.jackson.JacksonFeature;
import io.dropwizard.jersey.validation.HibernateValidationBinder;
import io.dropwizard.jersey.validation.Validators;
import io.dropwizard.lifecycle.Managed;
import jakarta.validation.Validator;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.RxInvokerProvider;
import jakarta.ws.rs.core.Configuration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.jspecify.annotations.Nullable;

public class JerseyClientBuilder {
    private final List<Object> singletons = new ArrayList<Object>();
    private final List<Class<?>> providers = new ArrayList();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private JerseyClientConfiguration configuration = new JerseyClientConfiguration();
    private HttpClientBuilder apacheHttpClientBuilder;
    private Validator validator = Validators.newValidator();
    private @Nullable Environment environment;
    private @Nullable ObjectMapper objectMapper;
    private @Nullable ExecutorService executorService;
    private @Nullable ConnectorProvider connectorProvider;

    public JerseyClientBuilder(Environment environment) {
        this.apacheHttpClientBuilder = new HttpClientBuilder(environment);
        this.environment = environment;
    }

    public JerseyClientBuilder(MetricRegistry metricRegistry) {
        this.apacheHttpClientBuilder = new HttpClientBuilder(metricRegistry);
    }

    public void setApacheHttpClientBuilder(HttpClientBuilder apacheHttpClientBuilder) {
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
    }

    public JerseyClientBuilder withProvider(Object provider) {
        this.singletons.add(Objects.requireNonNull(provider));
        return this;
    }

    public JerseyClientBuilder withProvider(Class<?> klass) {
        this.providers.add(Objects.requireNonNull(klass));
        return this;
    }

    public JerseyClientBuilder withProperty(String propertyName, Object propertyValue) {
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    public JerseyClientBuilder using(JerseyClientConfiguration configuration) {
        this.configuration = configuration;
        this.apacheHttpClientBuilder.using(configuration);
        return this;
    }

    public JerseyClientBuilder using(Environment environment) {
        this.environment = environment;
        return this;
    }

    public JerseyClientBuilder using(Validator validator) {
        this.validator = validator;
        return this;
    }

    public JerseyClientBuilder using(ExecutorService executorService, ObjectMapper objectMapper) {
        this.executorService = executorService;
        this.objectMapper = objectMapper;
        return this;
    }

    public JerseyClientBuilder using(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public JerseyClientBuilder using(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public JerseyClientBuilder using(ConnectorProvider connectorProvider) {
        this.connectorProvider = connectorProvider;
        return this;
    }

    public JerseyClientBuilder using(HttpRequestRetryStrategy httpRequestRetryStrategy) {
        this.apacheHttpClientBuilder.using(httpRequestRetryStrategy);
        return this;
    }

    public JerseyClientBuilder using(DnsResolver resolver) {
        this.apacheHttpClientBuilder.using(resolver);
        return this;
    }

    public JerseyClientBuilder using(HostnameVerifier verifier) {
        this.apacheHttpClientBuilder.using(verifier);
        return this;
    }

    public JerseyClientBuilder using(Registry<ConnectionSocketFactory> registry) {
        this.apacheHttpClientBuilder.using(registry);
        return this;
    }

    public JerseyClientBuilder using(HttpClientMetricNameStrategy metricNameStrategy) {
        this.apacheHttpClientBuilder.using(metricNameStrategy);
        return this;
    }

    public JerseyClientBuilder name(String environmentName) {
        this.apacheHttpClientBuilder.name(environmentName);
        return this;
    }

    public JerseyClientBuilder using(HttpRoutePlanner routePlanner) {
        this.apacheHttpClientBuilder.using(routePlanner);
        return this;
    }

    public JerseyClientBuilder using(CredentialsStore credentialsStore) {
        this.apacheHttpClientBuilder.using(credentialsStore);
        return this;
    }

    public <RX extends RxInvokerProvider<?>> Client buildRx(String name, Class<RX> invokerType) {
        return (Client)this.build(name).register(invokerType);
    }

    public Client build(String name) {
        if (this.environment == null && (this.executorService == null || this.objectMapper == null)) {
            throw new IllegalStateException("Must have either an environment or both an executor service and an object mapper");
        }
        if (this.executorService == null) {
            this.executorService = Objects.requireNonNull(this.environment).lifecycle().executorService("jersey-client-" + name + "-%d").minThreads(this.configuration.getMinThreads()).maxThreads(this.configuration.getMaxThreads()).workQueue(new ArrayBlockingQueue(this.configuration.getWorkQueueSize())).build();
        }
        if (this.objectMapper == null) {
            this.objectMapper = Objects.requireNonNull(this.environment).getObjectMapper();
        }
        if (this.environment != null) {
            this.validator = this.environment.getValidator();
        }
        return this.build(name, this.executorService, this.objectMapper, this.validator);
    }

    private Client build(String name, ExecutorService threadPool, ObjectMapper objectMapper, Validator validator) {
        if (!this.configuration.isGzipEnabled()) {
            this.apacheHttpClientBuilder.disableContentCompression(true);
        }
        JerseyClient client = org.glassfish.jersey.client.JerseyClientBuilder.createClient((Configuration)this.buildConfig(name, threadPool, objectMapper, validator));
        client.register((Object)new JerseyIgnoreRequestUserAgentHeaderFilter());
        if (this.environment != null) {
            this.environment.lifecycle().manage(new Managed(){
                final /* synthetic */ Client val$client;
                {
                    this.val$client = client;
                }

                public void stop() {
                    this.val$client.close();
                }
            });
        }
        if (this.configuration.isGzipEnabled()) {
            client.register((Object)new GZipDecoder());
            client.register((Object)new ConfiguredGZipEncoder(this.configuration.isGzipEnabledForRequests()));
        }
        return client;
    }

    private Configuration buildConfig(String name, ExecutorService threadPool, ObjectMapper objectMapper, Validator validator) {
        ClientConfig config = new ClientConfig();
        for (Object object : this.singletons) {
            config.register(object);
        }
        for (Class clazz : this.providers) {
            config.register(clazz);
        }
        config.register((Object)new JacksonFeature(objectMapper));
        config.register((Object)new HibernateValidationBinder(validator));
        for (Map.Entry entry : this.properties.entrySet()) {
            config.property((String)entry.getKey(), entry.getValue());
        }
        config.register((Object)new DropwizardExecutorProvider(threadPool));
        if (this.connectorProvider == null) {
            ConfiguredCloseableHttpClient apacheHttpClient = this.apacheHttpClientBuilder.buildWithDefaultRequestConfiguration(name);
            config.connectorProvider((client, runtimeConfig) -> this.createDropwizardApacheConnector(apacheHttpClient));
        } else {
            config.connectorProvider(this.connectorProvider);
        }
        return config;
    }

    protected DropwizardApacheConnector createDropwizardApacheConnector(ConfiguredCloseableHttpClient configuredClient) {
        return new DropwizardApacheConnector(configuredClient.getClient(), configuredClient.getDefaultRequestConfig(), this.configuration.isChunkedEncodingEnabled());
    }
}

