/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.workflow.Workflow;
import io.digdag.core.workflow.WorkflowTaskList;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableWorkflow
extends Workflow {
    private final String name;
    private final Config meta;
    private final WorkflowTaskList tasks;

    private ImmutableWorkflow(String name, Config meta, WorkflowTaskList tasks) {
        this.name = name;
        this.meta = meta;
        this.tasks = tasks;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="meta")
    public Config getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty(value="tasks")
    public WorkflowTaskList getTasks() {
        return this.tasks;
    }

    public final ImmutableWorkflow withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return ImmutableWorkflow.validate(new ImmutableWorkflow(newValue, this.meta, this.tasks));
    }

    public final ImmutableWorkflow withMeta(Config value) {
        if (this.meta == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"meta");
        return ImmutableWorkflow.validate(new ImmutableWorkflow(this.name, newValue, this.tasks));
    }

    public final ImmutableWorkflow withTasks(WorkflowTaskList value) {
        if (this.tasks == value) {
            return this;
        }
        WorkflowTaskList newValue = (WorkflowTaskList)Preconditions.checkNotNull((Object)value, (Object)"tasks");
        return ImmutableWorkflow.validate(new ImmutableWorkflow(this.name, this.meta, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflow && this.equalTo((ImmutableWorkflow)another);
    }

    private boolean equalTo(ImmutableWorkflow another) {
        return this.name.equals(another.name) && this.meta.equals((Object)another.meta) && this.tasks.equals(another.tasks);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.meta.hashCode();
        h = h * 17 + this.tasks.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Workflow").omitNullValues().add("name", (Object)this.name).add("meta", (Object)this.meta).add("tasks", (Object)this.tasks).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWorkflow fromJson(Json json) {
        Builder builder = ImmutableWorkflow.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.tasks != null) {
            builder.tasks(json.tasks);
        }
        return builder.build();
    }

    private static ImmutableWorkflow validate(ImmutableWorkflow instance) {
        instance.check();
        return instance;
    }

    public static ImmutableWorkflow copyOf(Workflow instance) {
        if (instance instanceof ImmutableWorkflow) {
            return (ImmutableWorkflow)instance;
        }
        return ImmutableWorkflow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_META = 2L;
        private static final long INIT_BIT_TASKS = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private Config meta;
        @Nullable
        private WorkflowTaskList tasks;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Workflow instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.name(instance.getName());
            this.meta(instance.getMeta());
            this.tasks(instance.getTasks());
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="meta")
        @CanIgnoreReturnValue
        public final Builder meta(Config meta) {
            this.meta = (Config)Preconditions.checkNotNull((Object)meta, (Object)"meta");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="tasks")
        @CanIgnoreReturnValue
        public final Builder tasks(WorkflowTaskList tasks) {
            this.tasks = (WorkflowTaskList)Preconditions.checkNotNull((Object)tasks, (Object)"tasks");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableWorkflow build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableWorkflow.validate(new ImmutableWorkflow(this.name, this.meta, this.tasks));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("meta");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("tasks");
            }
            return "Cannot build Workflow, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends Workflow {
        @Nullable
        String name;
        @Nullable
        Config meta;
        @Nullable
        WorkflowTaskList tasks;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="meta")
        public void setMeta(Config meta) {
            this.meta = meta;
        }

        @JsonProperty(value="tasks")
        public void setTasks(WorkflowTaskList tasks) {
            this.tasks = tasks;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WorkflowTaskList getTasks() {
            throw new UnsupportedOperationException();
        }
    }
}

