/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.workflow;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.core.agent.RuntimeParams;
import io.digdag.core.repository.StoredRevision;
import io.digdag.core.repository.StoredWorkflowDefinition;
import io.digdag.core.repository.StoredWorkflowDefinitionWithProject;
import io.digdag.core.repository.WorkflowDefinition;
import io.digdag.core.schedule.SchedulerManager;
import io.digdag.core.session.SessionMonitor;
import io.digdag.core.workflow.AttemptRequest;
import io.digdag.core.workflow.ImmutableAttemptRequest;
import io.digdag.core.workflow.SlaCalculator;
import io.digdag.spi.ScheduleTime;
import io.digdag.spi.Scheduler;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;

public class AttemptBuilder {
    private final SchedulerManager schedulerManager;
    private final SlaCalculator slaCalculator;

    @Inject
    public AttemptBuilder(SchedulerManager schedulerManager, SlaCalculator slaCalculator) {
        this.schedulerManager = schedulerManager;
        this.slaCalculator = slaCalculator;
    }

    public AttemptRequest buildFromStoredWorkflow(StoredRevision rev, StoredWorkflowDefinition def, Config overrideParams, ScheduleTime time) {
        return this.buildFromStoredWorkflow(rev, def, overrideParams, time, (Optional<String>)Optional.absent(), (Optional<Long>)Optional.absent(), (List<Long>)ImmutableList.of());
    }

    public AttemptRequest buildFromStoredWorkflow(StoredRevision rev, StoredWorkflowDefinition def, Config overrideParams, ScheduleTime time, Optional<String> retryAttemptName, Optional<Long> resumingAttemptId, List<Long> resumingTasks) {
        ZoneId timeZone = def.getTimeZone();
        Config sessionParams = this.buildSessionParameters(overrideParams, this.schedulerManager.tryGetScheduler(rev, def), time.getTime(), timeZone, (Optional<Instant>)Optional.absent());
        return ImmutableAttemptRequest.builder().stored(AttemptRequest.Stored.of(rev, def)).workflowName(def.getName()).sessionMonitors(this.buildSessionMonitors(def, time.getRunTime(), timeZone)).timeZone(timeZone).sessionParams(sessionParams).retryAttemptName(retryAttemptName).sessionTime(time.getTime()).resumingAttemptId(resumingAttemptId).resumingTasks(resumingTasks).build();
    }

    public AttemptRequest buildFromStoredWorkflow(StoredWorkflowDefinitionWithProject def, Config overrideParams, ScheduleTime time) {
        return this.buildFromStoredWorkflow(def, overrideParams, time, (Optional<String>)Optional.absent(), (Optional<Long>)Optional.absent(), (List<Long>)ImmutableList.of(), (Optional<Instant>)Optional.absent());
    }

    public AttemptRequest buildFromStoredWorkflow(StoredWorkflowDefinitionWithProject def, Config overrideParams, ScheduleTime time, Optional<String> retryAttemptName, Optional<Long> resumingAttemptId, List<Long> resumingTasks, Optional<Instant> lastSessionTime) {
        ZoneId timeZone = def.getTimeZone();
        Config sessionParams = this.buildSessionParameters(overrideParams, this.schedulerManager.tryGetScheduler(def), time.getTime(), timeZone, lastSessionTime);
        return ImmutableAttemptRequest.builder().stored(AttemptRequest.Stored.of(def)).workflowName(def.getName()).sessionMonitors(this.buildSessionMonitors(def, time.getRunTime(), timeZone)).timeZone(timeZone).sessionParams(sessionParams).retryAttemptName(retryAttemptName).sessionTime(time.getTime()).resumingAttemptId(resumingAttemptId).resumingTasks(resumingTasks).build();
    }

    private List<SessionMonitor> buildSessionMonitors(WorkflowDefinition def, Instant runTime, ZoneId timeZone) {
        ImmutableList.Builder monitors = ImmutableList.builder();
        if (def.getConfig().has("sla")) {
            Config slaConfig = def.getConfig().getNestedOrGetEmpty("sla");
            Instant triggerTime = this.slaCalculator.getTriggerTime(slaConfig, runTime, timeZone);
            monitors.add((Object)SessionMonitor.of("sla", slaConfig, triggerTime));
        }
        return monitors.build();
    }

    private Config buildSessionParameters(Config overrideParams, Optional<Scheduler> sr, Instant sessionTime, ZoneId timeZone, Optional<Instant> lastExecutedSessionTime) {
        Config params = overrideParams.deepCopy();
        if (sr.isPresent()) {
            Instant lastSessionTime = ((Scheduler)sr.get()).lastScheduleTime(sessionTime).getTime();
            Instant nextSessionTime = ((Scheduler)sr.get()).nextScheduleTime(sessionTime).getTime();
            params.set("last_session_time", (Object)RuntimeParams.formatSessionTime(lastSessionTime, timeZone));
            params.set("next_session_time", (Object)RuntimeParams.formatSessionTime(nextSessionTime, timeZone));
            if (lastExecutedSessionTime.isPresent()) {
                params.set("last_executed_session_time", (Object)RuntimeParams.formatSessionTime((Instant)lastExecutedSessionTime.get(), timeZone));
            }
        }
        return params;
    }
}

