/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.storage;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.spi.Storage;
import io.digdag.spi.StorageFactory;
import java.util.Map;
import java.util.Set;

public class StorageManager {
    private final Map<String, StorageFactory> registry;
    static final BaseEncoding HEX = BaseEncoding.base16().lowerCase().omitPadding();

    @Inject
    public StorageManager(Set<StorageFactory> factories) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (StorageFactory factory : factories) {
            builder.put((Object)factory.getType(), (Object)factory);
        }
        this.registry = builder.build();
    }

    public Storage create(Config systemConfig, String configKeyPrefix) {
        String type = (String)systemConfig.get(configKeyPrefix + "type", String.class);
        return this.create(type, systemConfig, configKeyPrefix);
    }

    public Storage create(String type, Config systemConfig, String configKeyPrefix) {
        Config config = StorageManager.extractKeyPrefix(systemConfig, configKeyPrefix + type + ".");
        StorageFactory factory = this.registry.get(type);
        if (factory == null) {
            throw new ConfigException("Unknown storage type: " + type);
        }
        return factory.newStorage(config);
    }

    public static Config extractKeyPrefix(Config config, String configKeyPrefix) {
        Config extracted = config.getFactory().create();
        for (String key : config.getKeys()) {
            if (!key.startsWith(configKeyPrefix)) continue;
            extracted.set(key.substring(configKeyPrefix.length()), (Object)((JsonNode)config.get(key, JsonNode.class)).deepCopy());
        }
        return extracted;
    }

    public static String encodeHex(byte[] hexBin) {
        return HEX.encode(hexBin);
    }

    public static byte[] decodeHex(String hexStr) {
        return HEX.decode((CharSequence)hexStr);
    }
}

