/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import io.digdag.client.config.ConfigException;
import io.digdag.client.config.ConfigFactory;
import io.digdag.core.BackgroundExecutor;
import io.digdag.core.ErrorReporter;
import io.digdag.core.Limits;
import io.digdag.core.database.TransactionManager;
import io.digdag.core.log.LogMarkers;
import io.digdag.core.repository.ModelValidationException;
import io.digdag.core.repository.ResourceNotFoundException;
import io.digdag.core.session.SessionStoreManager;
import io.digdag.core.session.StoredSessionMonitor;
import io.digdag.core.workflow.TaskControl;
import io.digdag.core.workflow.Tasks;
import io.digdag.core.workflow.WorkflowExecutor;
import io.digdag.spi.metrics.DigdagMetrics;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionMonitorExecutor
implements BackgroundExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SessionMonitorExecutor.class);
    private final ConfigFactory cf;
    private final SessionStoreManager sm;
    private final WorkflowExecutor exec;
    private final TransactionManager tm;
    private final Limits limits;
    private ScheduledExecutorService executor;
    @Inject(optional=true)
    private ErrorReporter errorReporter = ErrorReporter.empty();
    @Inject
    private DigdagMetrics metrics;

    @Inject
    public SessionMonitorExecutor(ConfigFactory cf, SessionStoreManager sm, TransactionManager tm, WorkflowExecutor exec, Limits limits) {
        this.cf = cf;
        this.sm = sm;
        this.tm = tm;
        this.exec = exec;
        this.limits = limits;
    }

    @PostConstruct
    public synchronized void start() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("session-monitor-scheduler-%d").build());
        }
        this.executor.scheduleWithFixedDelay(() -> this.run(), 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public synchronized void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    @Override
    public void eagerShutdown() {
        this.shutdown();
    }

    public void run() {
        try {
            this.tm.begin(() -> {
                this.sm.lockReadySessionMonitors(Instant.now(), storedMonitor -> {
                    try {
                        return this.runMonitor(storedMonitor);
                    }
                    catch (ConfigException | ModelValidationException e) {
                        logger.error("Failed to schedule a session monitor task due to deterministic error. This won't be retried.", e);
                        return Optional.absent();
                    }
                });
                return null;
            });
        }
        catch (Throwable t) {
            logger.error(LogMarkers.UNEXPECTED_SERVER_ERROR, "An uncaught exception is ignored. This session monitor scheduling will be retried.", t);
            this.errorReporter.reportUncaughtError(t);
            this.metrics.increment(DigdagMetrics.Category.DEFAULT, "uncaughtErrors");
        }
    }

    public Optional<Instant> runMonitor(StoredSessionMonitor storedMonitor) {
        this.sm.lockAttemptIfExists(storedMonitor.getAttemptId(), (sessionAttemptControlStore, summary) -> {
            if (!summary.getStateFlags().isDone()) {
                try {
                    return sessionAttemptControlStore.lockRootTask(summary.getId(), (store, storedTask) -> {
                        if (!Tasks.isDone(storedTask.getState())) {
                            this.exec.addMonitorTask(new TaskControl(store, storedTask, this.limits), storedMonitor.getType(), storedMonitor.getConfig());
                            return true;
                        }
                        return false;
                    });
                }
                catch (ResourceNotFoundException ex) {
                    return false;
                }
            }
            return false;
        }).or((Object)false);
        return Optional.absent();
    }
}

