/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Optional;
import io.digdag.client.config.Config;
import io.digdag.core.repository.ModelValidator;
import io.digdag.core.session.ImmutableSessionAttempt;
import java.time.ZoneId;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableSessionAttempt.class)
public abstract class SessionAttempt {
    public abstract Optional<String> getRetryAttemptName();

    public abstract Optional<Long> getWorkflowDefinitionId();

    public abstract ZoneId getTimeZone();

    public abstract Config getParams();

    public static SessionAttempt ofStoredWorkflowDefinition(Optional<String> retryAttemptName, Config params, ZoneId timeZone, long storedWorkflowDefinitionId) {
        return SessionAttempt.of(retryAttemptName, params, timeZone, (Optional<Long>)Optional.of((Object)storedWorkflowDefinitionId));
    }

    public static SessionAttempt ofOneShotWorkflow(Optional<String> retryAttemptName, ZoneId timeZone, Config params) {
        return SessionAttempt.of(retryAttemptName, params, timeZone, (Optional<Long>)Optional.absent());
    }

    public static SessionAttempt of(Optional<String> retryAttemptName, Config params, ZoneId timeZone, Optional<Long> storedWorkflowDefinitionId) {
        return ImmutableSessionAttempt.builder().retryAttemptName(retryAttemptName).workflowDefinitionId(storedWorkflowDefinitionId).timeZone(timeZone).params(params).build();
    }

    @Value.Check
    protected void check() {
        ModelValidator validator = ModelValidator.builder();
        if (this.getRetryAttemptName().isPresent()) {
            validator.checkIdentifierName("retry attempt name", (String)this.getRetryAttemptName().get());
        }
        validator.validate("session attempt", this);
    }
}

