/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.client.config.Config;
import io.digdag.core.session.SessionMonitor;
import io.digdag.core.session.StoredSessionMonitor;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStoredSessionMonitor
extends StoredSessionMonitor {
    private final long id;
    private final long attemptId;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String type;
    private final Config config;
    private final Instant nextRunTime;

    private ImmutableStoredSessionMonitor(long id, long attemptId, Instant createdAt, Instant updatedAt, String type, Config config, Instant nextRunTime) {
        this.id = id;
        this.attemptId = attemptId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.type = type;
        this.config = config;
        this.nextRunTime = nextRunTime;
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="attemptId")
    public long getAttemptId() {
        return this.attemptId;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="nextRunTime")
    public Instant getNextRunTime() {
        return this.nextRunTime;
    }

    public final ImmutableStoredSessionMonitor withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableStoredSessionMonitor(value, this.attemptId, this.createdAt, this.updatedAt, this.type, this.config, this.nextRunTime);
    }

    public final ImmutableStoredSessionMonitor withAttemptId(long value) {
        if (this.attemptId == value) {
            return this;
        }
        return new ImmutableStoredSessionMonitor(this.id, value, this.createdAt, this.updatedAt, this.type, this.config, this.nextRunTime);
    }

    public final ImmutableStoredSessionMonitor withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableStoredSessionMonitor(this.id, this.attemptId, newValue, this.updatedAt, this.type, this.config, this.nextRunTime);
    }

    public final ImmutableStoredSessionMonitor withUpdatedAt(Instant value) {
        if (this.updatedAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"updatedAt");
        return new ImmutableStoredSessionMonitor(this.id, this.attemptId, this.createdAt, newValue, this.type, this.config, this.nextRunTime);
    }

    public final ImmutableStoredSessionMonitor withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"type");
        return new ImmutableStoredSessionMonitor(this.id, this.attemptId, this.createdAt, this.updatedAt, newValue, this.config, this.nextRunTime);
    }

    public final ImmutableStoredSessionMonitor withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"config");
        return new ImmutableStoredSessionMonitor(this.id, this.attemptId, this.createdAt, this.updatedAt, this.type, newValue, this.nextRunTime);
    }

    public final ImmutableStoredSessionMonitor withNextRunTime(Instant value) {
        if (this.nextRunTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"nextRunTime");
        return new ImmutableStoredSessionMonitor(this.id, this.attemptId, this.createdAt, this.updatedAt, this.type, this.config, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredSessionMonitor && this.equalTo((ImmutableStoredSessionMonitor)another);
    }

    private boolean equalTo(ImmutableStoredSessionMonitor another) {
        return this.id == another.id && this.attemptId == another.attemptId && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.type.equals(another.type) && this.config.equals((Object)another.config) && this.nextRunTime.equals(another.nextRunTime);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.id);
        h = h * 17 + Longs.hashCode((long)this.attemptId);
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.updatedAt.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.nextRunTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredSessionMonitor").omitNullValues().add("id", this.id).add("attemptId", this.attemptId).add("createdAt", (Object)this.createdAt).add("updatedAt", (Object)this.updatedAt).add("type", (Object)this.type).add("config", (Object)this.config).add("nextRunTime", (Object)this.nextRunTime).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredSessionMonitor fromJson(Json json) {
        Builder builder = ImmutableStoredSessionMonitor.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.attemptIdIsSet) {
            builder.attemptId(json.attemptId);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.nextRunTime != null) {
            builder.nextRunTime(json.nextRunTime);
        }
        return builder.build();
    }

    public static ImmutableStoredSessionMonitor copyOf(StoredSessionMonitor instance) {
        if (instance instanceof ImmutableStoredSessionMonitor) {
            return (ImmutableStoredSessionMonitor)instance;
        }
        return ImmutableStoredSessionMonitor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ATTEMPT_ID = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private static final long INIT_BIT_CONFIG = 32L;
        private static final long INIT_BIT_NEXT_RUN_TIME = 64L;
        private long initBits = 127L;
        private long id;
        private long attemptId;
        @Nullable
        private Instant createdAt;
        @Nullable
        private Instant updatedAt;
        @Nullable
        private String type;
        @Nullable
        private Config config;
        @Nullable
        private Instant nextRunTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredSessionMonitor instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SessionMonitor instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SessionMonitor instance;
            if (object instanceof StoredSessionMonitor) {
                instance = (StoredSessionMonitor)object;
                this.createdAt(((StoredSessionMonitor)instance).getCreatedAt());
                this.id(((StoredSessionMonitor)instance).getId());
                this.attemptId(((StoredSessionMonitor)instance).getAttemptId());
                this.updatedAt(((StoredSessionMonitor)instance).getUpdatedAt());
            }
            if (object instanceof SessionMonitor) {
                instance = (SessionMonitor)object;
                this.type(instance.getType());
                this.config(instance.getConfig());
                this.nextRunTime(instance.getNextRunTime());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="attemptId")
        @CanIgnoreReturnValue
        public final Builder attemptId(long attemptId) {
            this.attemptId = attemptId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="updatedAt")
        @CanIgnoreReturnValue
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = (Instant)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="nextRunTime")
        @CanIgnoreReturnValue
        public final Builder nextRunTime(Instant nextRunTime) {
            this.nextRunTime = (Instant)Preconditions.checkNotNull((Object)nextRunTime, (Object)"nextRunTime");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableStoredSessionMonitor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStoredSessionMonitor(this.id, this.attemptId, this.createdAt, this.updatedAt, this.type, this.config, this.nextRunTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("attemptId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("nextRunTime");
            }
            return "Cannot build StoredSessionMonitor, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends StoredSessionMonitor {
        long id;
        boolean idIsSet;
        long attemptId;
        boolean attemptIdIsSet;
        @Nullable
        Instant createdAt;
        @Nullable
        Instant updatedAt;
        @Nullable
        String type;
        @Nullable
        Config config;
        @Nullable
        Instant nextRunTime;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="attemptId")
        public void setAttemptId(long attemptId) {
            this.attemptId = attemptId;
            this.attemptIdIsSet = true;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updatedAt")
        public void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @JsonProperty(value="nextRunTime")
        public void setNextRunTime(Instant nextRunTime) {
            this.nextRunTime = nextRunTime;
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getAttemptId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getNextRunTime() {
            throw new UnsupportedOperationException();
        }
    }
}

