/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.session.StoredDelayedSessionAttempt;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableStoredDelayedSessionAttempt
extends StoredDelayedSessionAttempt {
    private final long attemptId;
    private final Optional<Long> dependentSessionId;
    private final Instant nextRunTime;
    private final Instant updatedAt;

    private ImmutableStoredDelayedSessionAttempt(long attemptId, Optional<Long> dependentSessionId, Instant nextRunTime, Instant updatedAt) {
        this.attemptId = attemptId;
        this.dependentSessionId = dependentSessionId;
        this.nextRunTime = nextRunTime;
        this.updatedAt = updatedAt;
    }

    @Override
    @JsonProperty(value="attemptId")
    public long getAttemptId() {
        return this.attemptId;
    }

    @Override
    @JsonProperty(value="dependentSessionId")
    public Optional<Long> getDependentSessionId() {
        return this.dependentSessionId;
    }

    @Override
    @JsonProperty(value="nextRunTime")
    public Instant getNextRunTime() {
        return this.nextRunTime;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public final ImmutableStoredDelayedSessionAttempt withAttemptId(long value) {
        if (this.attemptId == value) {
            return this;
        }
        return new ImmutableStoredDelayedSessionAttempt(value, this.dependentSessionId, this.nextRunTime, this.updatedAt);
    }

    public final ImmutableStoredDelayedSessionAttempt withDependentSessionId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.dependentSessionId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableStoredDelayedSessionAttempt(this.attemptId, (Optional<Long>)newValue, this.nextRunTime, this.updatedAt);
    }

    public final ImmutableStoredDelayedSessionAttempt withDependentSessionId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"dependentSessionId");
        if (this.dependentSessionId.equals((Object)value)) {
            return this;
        }
        return new ImmutableStoredDelayedSessionAttempt(this.attemptId, (Optional<Long>)value, this.nextRunTime, this.updatedAt);
    }

    public final ImmutableStoredDelayedSessionAttempt withNextRunTime(Instant value) {
        if (this.nextRunTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"nextRunTime");
        return new ImmutableStoredDelayedSessionAttempt(this.attemptId, this.dependentSessionId, newValue, this.updatedAt);
    }

    public final ImmutableStoredDelayedSessionAttempt withUpdatedAt(Instant value) {
        if (this.updatedAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"updatedAt");
        return new ImmutableStoredDelayedSessionAttempt(this.attemptId, this.dependentSessionId, this.nextRunTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredDelayedSessionAttempt && this.equalTo((ImmutableStoredDelayedSessionAttempt)another);
    }

    private boolean equalTo(ImmutableStoredDelayedSessionAttempt another) {
        return this.attemptId == another.attemptId && this.dependentSessionId.equals(another.dependentSessionId) && this.nextRunTime.equals(another.nextRunTime) && this.updatedAt.equals(another.updatedAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.attemptId);
        h = h * 17 + this.dependentSessionId.hashCode();
        h = h * 17 + this.nextRunTime.hashCode();
        h = h * 17 + this.updatedAt.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredDelayedSessionAttempt").omitNullValues().add("attemptId", this.attemptId).add("dependentSessionId", this.dependentSessionId.orNull()).add("nextRunTime", (Object)this.nextRunTime).add("updatedAt", (Object)this.updatedAt).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStoredDelayedSessionAttempt fromJson(Json json) {
        Builder builder = ImmutableStoredDelayedSessionAttempt.builder();
        if (json.attemptIdIsSet) {
            builder.attemptId(json.attemptId);
        }
        if (json.dependentSessionId != null) {
            builder.dependentSessionId(json.dependentSessionId);
        }
        if (json.nextRunTime != null) {
            builder.nextRunTime(json.nextRunTime);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        return builder.build();
    }

    public static ImmutableStoredDelayedSessionAttempt copyOf(StoredDelayedSessionAttempt instance) {
        if (instance instanceof ImmutableStoredDelayedSessionAttempt) {
            return (ImmutableStoredDelayedSessionAttempt)instance;
        }
        return ImmutableStoredDelayedSessionAttempt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ATTEMPT_ID = 1L;
        private static final long INIT_BIT_NEXT_RUN_TIME = 2L;
        private static final long INIT_BIT_UPDATED_AT = 4L;
        private long initBits = 7L;
        private long attemptId;
        private Optional<Long> dependentSessionId = Optional.absent();
        @Nullable
        private Instant nextRunTime;
        @Nullable
        private Instant updatedAt;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StoredDelayedSessionAttempt instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.attemptId(instance.getAttemptId());
            Optional<Long> dependentSessionIdOptional = instance.getDependentSessionId();
            if (dependentSessionIdOptional.isPresent()) {
                this.dependentSessionId(dependentSessionIdOptional);
            }
            this.nextRunTime(instance.getNextRunTime());
            this.updatedAt(instance.getUpdatedAt());
            return this;
        }

        @JsonProperty(value="attemptId")
        @CanIgnoreReturnValue
        public final Builder attemptId(long attemptId) {
            this.attemptId = attemptId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dependentSessionId(long dependentSessionId) {
            this.dependentSessionId = Optional.of((Object)dependentSessionId);
            return this;
        }

        @JsonProperty(value="dependentSessionId")
        @CanIgnoreReturnValue
        public final Builder dependentSessionId(Optional<Long> dependentSessionId) {
            this.dependentSessionId = (Optional)Preconditions.checkNotNull(dependentSessionId, (Object)"dependentSessionId");
            return this;
        }

        @JsonProperty(value="nextRunTime")
        @CanIgnoreReturnValue
        public final Builder nextRunTime(Instant nextRunTime) {
            this.nextRunTime = (Instant)Preconditions.checkNotNull((Object)nextRunTime, (Object)"nextRunTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="updatedAt")
        @CanIgnoreReturnValue
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = (Instant)Preconditions.checkNotNull((Object)updatedAt, (Object)"updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableStoredDelayedSessionAttempt build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStoredDelayedSessionAttempt(this.attemptId, this.dependentSessionId, this.nextRunTime, this.updatedAt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("attemptId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nextRunTime");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("updatedAt");
            }
            return "Cannot build StoredDelayedSessionAttempt, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends StoredDelayedSessionAttempt {
        long attemptId;
        boolean attemptIdIsSet;
        Optional<Long> dependentSessionId = Optional.absent();
        @Nullable
        Instant nextRunTime;
        @Nullable
        Instant updatedAt;

        Json() {
        }

        @JsonProperty(value="attemptId")
        public void setAttemptId(long attemptId) {
            this.attemptId = attemptId;
            this.attemptIdIsSet = true;
        }

        @JsonProperty(value="dependentSessionId")
        public void setDependentSessionId(Optional<Long> dependentSessionId) {
            this.dependentSessionId = dependentSessionId;
        }

        @JsonProperty(value="nextRunTime")
        public void setNextRunTime(Instant nextRunTime) {
            this.nextRunTime = nextRunTime;
        }

        @JsonProperty(value="updatedAt")
        public void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public long getAttemptId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getDependentSessionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getNextRunTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getUpdatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

