/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.session.AttemptStateFlags;
import io.digdag.core.session.SessionAttemptSummary;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableSessionAttemptSummary
extends SessionAttemptSummary {
    private final long id;
    private final long sessionId;
    private final int index;
    private final AttemptStateFlags stateFlags;

    private ImmutableSessionAttemptSummary(long id, long sessionId, int index, AttemptStateFlags stateFlags) {
        this.id = id;
        this.sessionId = sessionId;
        this.index = index;
        this.stateFlags = stateFlags;
    }

    @Override
    @JsonProperty(value="id")
    public long getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="sessionId")
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    @JsonProperty(value="index")
    public int getIndex() {
        return this.index;
    }

    @Override
    @JsonProperty(value="stateFlags")
    public AttemptStateFlags getStateFlags() {
        return this.stateFlags;
    }

    public final ImmutableSessionAttemptSummary withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableSessionAttemptSummary(value, this.sessionId, this.index, this.stateFlags);
    }

    public final ImmutableSessionAttemptSummary withSessionId(long value) {
        if (this.sessionId == value) {
            return this;
        }
        return new ImmutableSessionAttemptSummary(this.id, value, this.index, this.stateFlags);
    }

    public final ImmutableSessionAttemptSummary withIndex(int value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableSessionAttemptSummary(this.id, this.sessionId, value, this.stateFlags);
    }

    public final ImmutableSessionAttemptSummary withStateFlags(AttemptStateFlags value) {
        if (this.stateFlags == value) {
            return this;
        }
        AttemptStateFlags newValue = (AttemptStateFlags)Preconditions.checkNotNull((Object)value, (Object)"stateFlags");
        return new ImmutableSessionAttemptSummary(this.id, this.sessionId, this.index, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSessionAttemptSummary && this.equalTo((ImmutableSessionAttemptSummary)another);
    }

    private boolean equalTo(ImmutableSessionAttemptSummary another) {
        return this.id == another.id && this.sessionId == another.sessionId && this.index == another.index && this.stateFlags.equals(another.stateFlags);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.id);
        h = h * 17 + Longs.hashCode((long)this.sessionId);
        h = h * 17 + this.index;
        h = h * 17 + this.stateFlags.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SessionAttemptSummary").omitNullValues().add("id", this.id).add("sessionId", this.sessionId).add("index", this.index).add("stateFlags", (Object)this.stateFlags).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSessionAttemptSummary fromJson(Json json) {
        Builder builder = ImmutableSessionAttemptSummary.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.sessionIdIsSet) {
            builder.sessionId(json.sessionId);
        }
        if (json.indexIsSet) {
            builder.index(json.index);
        }
        if (json.stateFlags != null) {
            builder.stateFlags(json.stateFlags);
        }
        return builder.build();
    }

    public static ImmutableSessionAttemptSummary copyOf(SessionAttemptSummary instance) {
        if (instance instanceof ImmutableSessionAttemptSummary) {
            return (ImmutableSessionAttemptSummary)instance;
        }
        return ImmutableSessionAttemptSummary.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SESSION_ID = 2L;
        private static final long INIT_BIT_INDEX = 4L;
        private static final long INIT_BIT_STATE_FLAGS = 8L;
        private long initBits = 15L;
        private long id;
        private long sessionId;
        private int index;
        @Nullable
        private AttemptStateFlags stateFlags;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SessionAttemptSummary instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.sessionId(instance.getSessionId());
            this.index(instance.getIndex());
            this.stateFlags(instance.getStateFlags());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="sessionId")
        @CanIgnoreReturnValue
        public final Builder sessionId(long sessionId) {
            this.sessionId = sessionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(int index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="stateFlags")
        @CanIgnoreReturnValue
        public final Builder stateFlags(AttemptStateFlags stateFlags) {
            this.stateFlags = (AttemptStateFlags)Preconditions.checkNotNull((Object)stateFlags, (Object)"stateFlags");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSessionAttemptSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSessionAttemptSummary(this.id, this.sessionId, this.index, this.stateFlags);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sessionId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("stateFlags");
            }
            return "Cannot build SessionAttemptSummary, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends SessionAttemptSummary {
        long id;
        boolean idIsSet;
        long sessionId;
        boolean sessionIdIsSet;
        int index;
        boolean indexIsSet;
        @Nullable
        AttemptStateFlags stateFlags;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(long id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="sessionId")
        public void setSessionId(long sessionId) {
            this.sessionId = sessionId;
            this.sessionIdIsSet = true;
        }

        @JsonProperty(value="index")
        public void setIndex(int index) {
            this.index = index;
            this.indexIsSet = true;
        }

        @JsonProperty(value="stateFlags")
        public void setStateFlags(AttemptStateFlags stateFlags) {
            this.stateFlags = stateFlags;
        }

        @Override
        public long getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSessionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AttemptStateFlags getStateFlags() {
            throw new UnsupportedOperationException();
        }
    }
}

