/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.session;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.session.Session;
import io.digdag.core.session.SessionImpl;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableSession
extends SessionImpl {
    private final int projectId;
    private final String workflowName;
    private final Instant sessionTime;

    private ImmutableSession(int projectId, String workflowName, Instant sessionTime) {
        this.projectId = projectId;
        this.workflowName = workflowName;
        this.sessionTime = sessionTime;
    }

    @Override
    @JsonProperty(value="projectId")
    public int getProjectId() {
        return this.projectId;
    }

    @Override
    @JsonProperty(value="workflowName")
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Override
    @JsonProperty(value="sessionTime")
    public Instant getSessionTime() {
        return this.sessionTime;
    }

    public final ImmutableSession withProjectId(int value) {
        if (this.projectId == value) {
            return this;
        }
        return new ImmutableSession(value, this.workflowName, this.sessionTime);
    }

    public final ImmutableSession withWorkflowName(String value) {
        if (this.workflowName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"workflowName");
        return new ImmutableSession(this.projectId, newValue, this.sessionTime);
    }

    public final ImmutableSession withSessionTime(Instant value) {
        if (this.sessionTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"sessionTime");
        return new ImmutableSession(this.projectId, this.workflowName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSession && this.equalTo((ImmutableSession)another);
    }

    private boolean equalTo(ImmutableSession another) {
        return this.projectId == another.projectId && this.workflowName.equals(another.workflowName) && this.sessionTime.equals(another.sessionTime);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.projectId;
        h = h * 17 + this.workflowName.hashCode();
        h = h * 17 + this.sessionTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Session").omitNullValues().add("projectId", this.projectId).add("workflowName", (Object)this.workflowName).add("sessionTime", (Object)this.sessionTime).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSession fromJson(Json json) {
        Builder builder = ImmutableSession.builder();
        if (json.projectIdIsSet) {
            builder.projectId(json.projectId);
        }
        if (json.workflowName != null) {
            builder.workflowName(json.workflowName);
        }
        if (json.sessionTime != null) {
            builder.sessionTime(json.sessionTime);
        }
        return builder.build();
    }

    public static ImmutableSession copyOf(SessionImpl instance) {
        if (instance instanceof ImmutableSession) {
            return (ImmutableSession)instance;
        }
        return ImmutableSession.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PROJECT_ID = 1L;
        private static final long INIT_BIT_WORKFLOW_NAME = 2L;
        private static final long INIT_BIT_SESSION_TIME = 4L;
        private long initBits = 7L;
        private int projectId;
        @Nullable
        private String workflowName;
        @Nullable
        private Instant sessionTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Session instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SessionImpl instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Session) {
                Session instance = (Session)object;
                this.projectId(instance.getProjectId());
                this.workflowName(instance.getWorkflowName());
                this.sessionTime(instance.getSessionTime());
            }
        }

        @JsonProperty(value="projectId")
        @CanIgnoreReturnValue
        public final Builder projectId(int projectId) {
            this.projectId = projectId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="workflowName")
        @CanIgnoreReturnValue
        public final Builder workflowName(String workflowName) {
            this.workflowName = (String)Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="sessionTime")
        @CanIgnoreReturnValue
        public final Builder sessionTime(Instant sessionTime) {
            this.sessionTime = (Instant)Preconditions.checkNotNull((Object)sessionTime, (Object)"sessionTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSession build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSession(this.projectId, this.workflowName, this.sessionTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("projectId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("workflowName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sessionTime");
            }
            return "Cannot build Session, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends SessionImpl {
        int projectId;
        boolean projectIdIsSet;
        @Nullable
        String workflowName;
        @Nullable
        Instant sessionTime;

        Json() {
        }

        @JsonProperty(value="projectId")
        public void setProjectId(int projectId) {
            this.projectId = projectId;
            this.projectIdIsSet = true;
        }

        @JsonProperty(value="workflowName")
        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @JsonProperty(value="sessionTime")
        public void setSessionTime(Instant sessionTime) {
            this.sessionTime = sessionTime;
        }

        @Override
        public int getProjectId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWorkflowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getSessionTime() {
            throw new UnsupportedOperationException();
        }
    }
}

