/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.core.schedule;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.digdag.core.schedule.Schedule;
import io.digdag.core.schedule.ScheduleImpl;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@SuppressFBWarnings
@Immutable
public final class ImmutableSchedule
extends ScheduleImpl {
    private final String workflowName;
    private final long workflowDefinitionId;
    private final Instant nextRunTime;
    private final Instant nextScheduleTime;

    private ImmutableSchedule(String workflowName, long workflowDefinitionId, Instant nextRunTime, Instant nextScheduleTime) {
        this.workflowName = workflowName;
        this.workflowDefinitionId = workflowDefinitionId;
        this.nextRunTime = nextRunTime;
        this.nextScheduleTime = nextScheduleTime;
    }

    @Override
    @JsonProperty(value="workflowName")
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Override
    @JsonProperty(value="workflowDefinitionId")
    public long getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    @Override
    @JsonProperty(value="nextRunTime")
    public Instant getNextRunTime() {
        return this.nextRunTime;
    }

    @Override
    @JsonProperty(value="nextScheduleTime")
    public Instant getNextScheduleTime() {
        return this.nextScheduleTime;
    }

    public final ImmutableSchedule withWorkflowName(String value) {
        if (this.workflowName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"workflowName");
        return new ImmutableSchedule(newValue, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableSchedule withWorkflowDefinitionId(long value) {
        if (this.workflowDefinitionId == value) {
            return this;
        }
        return new ImmutableSchedule(this.workflowName, value, this.nextRunTime, this.nextScheduleTime);
    }

    public final ImmutableSchedule withNextRunTime(Instant value) {
        if (this.nextRunTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"nextRunTime");
        return new ImmutableSchedule(this.workflowName, this.workflowDefinitionId, newValue, this.nextScheduleTime);
    }

    public final ImmutableSchedule withNextScheduleTime(Instant value) {
        if (this.nextScheduleTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"nextScheduleTime");
        return new ImmutableSchedule(this.workflowName, this.workflowDefinitionId, this.nextRunTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSchedule && this.equalTo((ImmutableSchedule)another);
    }

    private boolean equalTo(ImmutableSchedule another) {
        return this.workflowName.equals(another.workflowName) && this.workflowDefinitionId == another.workflowDefinitionId && this.nextRunTime.equals(another.nextRunTime) && this.nextScheduleTime.equals(another.nextScheduleTime);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.workflowName.hashCode();
        h = h * 17 + Longs.hashCode((long)this.workflowDefinitionId);
        h = h * 17 + this.nextRunTime.hashCode();
        h = h * 17 + this.nextScheduleTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Schedule").omitNullValues().add("workflowName", (Object)this.workflowName).add("workflowDefinitionId", this.workflowDefinitionId).add("nextRunTime", (Object)this.nextRunTime).add("nextScheduleTime", (Object)this.nextScheduleTime).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSchedule fromJson(Json json) {
        Builder builder = ImmutableSchedule.builder();
        if (json.workflowName != null) {
            builder.workflowName(json.workflowName);
        }
        if (json.workflowDefinitionIdIsSet) {
            builder.workflowDefinitionId(json.workflowDefinitionId);
        }
        if (json.nextRunTime != null) {
            builder.nextRunTime(json.nextRunTime);
        }
        if (json.nextScheduleTime != null) {
            builder.nextScheduleTime(json.nextScheduleTime);
        }
        return builder.build();
    }

    public static ImmutableSchedule copyOf(ScheduleImpl instance) {
        if (instance instanceof ImmutableSchedule) {
            return (ImmutableSchedule)instance;
        }
        return ImmutableSchedule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WORKFLOW_NAME = 1L;
        private static final long INIT_BIT_WORKFLOW_DEFINITION_ID = 2L;
        private static final long INIT_BIT_NEXT_RUN_TIME = 4L;
        private static final long INIT_BIT_NEXT_SCHEDULE_TIME = 8L;
        private long initBits = 15L;
        @Nullable
        private String workflowName;
        private long workflowDefinitionId;
        @Nullable
        private Instant nextRunTime;
        @Nullable
        private Instant nextScheduleTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Schedule instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ScheduleImpl instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Schedule) {
                Schedule instance = (Schedule)object;
                this.workflowDefinitionId(instance.getWorkflowDefinitionId());
                this.workflowName(instance.getWorkflowName());
                this.nextRunTime(instance.getNextRunTime());
                this.nextScheduleTime(instance.getNextScheduleTime());
            }
        }

        @JsonProperty(value="workflowName")
        @CanIgnoreReturnValue
        public final Builder workflowName(String workflowName) {
            this.workflowName = (String)Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="workflowDefinitionId")
        @CanIgnoreReturnValue
        public final Builder workflowDefinitionId(long workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="nextRunTime")
        @CanIgnoreReturnValue
        public final Builder nextRunTime(Instant nextRunTime) {
            this.nextRunTime = (Instant)Preconditions.checkNotNull((Object)nextRunTime, (Object)"nextRunTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="nextScheduleTime")
        @CanIgnoreReturnValue
        public final Builder nextScheduleTime(Instant nextScheduleTime) {
            this.nextScheduleTime = (Instant)Preconditions.checkNotNull((Object)nextScheduleTime, (Object)"nextScheduleTime");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSchedule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSchedule(this.workflowName, this.workflowDefinitionId, this.nextRunTime, this.nextScheduleTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("workflowName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("workflowDefinitionId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("nextRunTime");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("nextScheduleTime");
            }
            return "Cannot build Schedule, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScheduleImpl {
        @Nullable
        String workflowName;
        long workflowDefinitionId;
        boolean workflowDefinitionIdIsSet;
        @Nullable
        Instant nextRunTime;
        @Nullable
        Instant nextScheduleTime;

        Json() {
        }

        @JsonProperty(value="workflowName")
        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @JsonProperty(value="workflowDefinitionId")
        public void setWorkflowDefinitionId(long workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
            this.workflowDefinitionIdIsSet = true;
        }

        @JsonProperty(value="nextRunTime")
        public void setNextRunTime(Instant nextRunTime) {
            this.nextRunTime = nextRunTime;
        }

        @JsonProperty(value="nextScheduleTime")
        public void setNextScheduleTime(Instant nextScheduleTime) {
            this.nextScheduleTime = nextScheduleTime;
        }

        @Override
        public String getWorkflowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWorkflowDefinitionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getNextRunTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getNextScheduleTime() {
            throw new UnsupportedOperationException();
        }
    }
}

